/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.type;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.UnitNode;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ActionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterFunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.MatchClassFilterFunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ProcedureDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.RuleDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.SequenceDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.SubpatternDeclNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.CompoundTypeNode;
import de.unika.ipd.grgen.ast.type.DefinedMatchTypeNode;
import de.unika.ipd.grgen.ast.type.MatchTypeActionNode;
import de.unika.ipd.grgen.ast.type.MatchTypeIteratedNode;
import de.unika.ipd.grgen.ast.util.CollectResolver;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.Ident;
import de.unika.ipd.grgen.ir.executable.FilterFunction;
import de.unika.ipd.grgen.ir.executable.Function;
import de.unika.ipd.grgen.ir.executable.MatchClassFilterFunction;
import de.unika.ipd.grgen.ir.executable.Procedure;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.executable.Sequence;
import de.unika.ipd.grgen.ir.type.DefinedMatchType;
import de.unika.ipd.grgen.ir.type.MatchType;
import de.unika.ipd.grgen.ir.type.PackageActionType;
import de.unika.ipd.grgen.util.Base;
import java.util.Collection;
import java.util.Vector;

public class PackageActionTypeNode
extends CompoundTypeNode {
    private CollectNode<SubpatternDeclNode> subpatterns;
    private CollectNode<IdentNode> subpatternsUnresolved;
    private CollectNode<ActionDeclNode> actions;
    private CollectNode<IdentNode> actionsUnresolved;
    private CollectNode<MatchTypeActionNode> matchTypes;
    private CollectNode<IdentNode> matchTypesUnresolved;
    private CollectNode<FilterFunctionDeclNode> filterFunctions;
    private CollectNode<IdentNode> filterFunctionsUnresolved;
    private CollectNode<TypeDeclNode> matchClassDecls;
    private CollectNode<IdentNode> matchClassesUnresolved;
    private CollectNode<MatchClassFilterFunctionDeclNode> matchClassFilterFunctions;
    private CollectNode<IdentNode> matchClassFilterFunctionsUnresolved;
    private CollectNode<MatchTypeIteratedNode> matchTypesIterated;
    private CollectNode<IdentNode> matchTypesIteratedUnresolved;
    private CollectNode<FunctionDeclNode> functions;
    private CollectNode<IdentNode> functionsUnresolved;
    private CollectNode<ProcedureDeclNode> procedures;
    private CollectNode<IdentNode> proceduresUnresolved;
    private CollectNode<SequenceDeclNode> sequences;
    private CollectNode<IdentNode> sequencesUnresolved;
    private static final CollectResolver<SubpatternDeclNode> subpatternsResolver;
    private static final CollectResolver<ActionDeclNode> actionsResolver;
    private static CollectResolver<MatchTypeActionNode> matchTypesResolver;
    private static final CollectResolver<FilterFunctionDeclNode> filterFunctionsResolver;
    private static final CollectResolver<TypeDeclNode> matchClassesResolver;
    private static final CollectResolver<MatchClassFilterFunctionDeclNode> matchClassFilterFunctionsResolver;
    private static CollectResolver<MatchTypeIteratedNode> matchTypesIteratedResolver;
    private static final CollectResolver<FunctionDeclNode> functionsResolver;
    private static final CollectResolver<ProcedureDeclNode> proceduresResolver;
    private static final CollectResolver<SequenceDeclNode> sequencesResolver;

    public PackageActionTypeNode(CollectNode<IdentNode> collectNode, CollectNode<IdentNode> collectNode2, CollectNode<IdentNode> collectNode3, CollectNode<IdentNode> collectNode4, CollectNode<IdentNode> collectNode5, CollectNode<IdentNode> collectNode6, CollectNode<IdentNode> collectNode7, CollectNode<IdentNode> collectNode8, CollectNode<IdentNode> collectNode9, CollectNode<IdentNode> collectNode10) {
        this.subpatternsUnresolved = collectNode;
        this.becomeParent(this.subpatternsUnresolved);
        this.actionsUnresolved = collectNode2;
        this.becomeParent(this.actionsUnresolved);
        this.matchTypesUnresolved = collectNode3;
        this.becomeParent(this.matchTypesUnresolved);
        this.filterFunctionsUnresolved = collectNode4;
        this.becomeParent(this.filterFunctionsUnresolved);
        this.matchClassesUnresolved = collectNode5;
        this.becomeParent(this.matchClassesUnresolved);
        this.matchClassFilterFunctionsUnresolved = collectNode6;
        this.becomeParent(this.matchClassFilterFunctionsUnresolved);
        this.matchTypesIteratedUnresolved = collectNode7;
        this.becomeParent(this.matchTypesIteratedUnresolved);
        this.functionsUnresolved = collectNode8;
        this.becomeParent(this.functionsUnresolved);
        this.proceduresUnresolved = collectNode9;
        this.becomeParent(this.proceduresUnresolved);
        this.sequencesUnresolved = collectNode10;
        this.becomeParent(this.sequencesUnresolved);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.subpatternsUnresolved, this.subpatterns));
        vector.add(this.getValidVersion(this.actionsUnresolved, this.actions));
        vector.add(this.getValidVersion(this.matchTypesUnresolved, this.matchTypes));
        vector.add(this.getValidVersion(this.filterFunctionsUnresolved, this.filterFunctions));
        vector.add(this.getValidVersion(this.matchClassesUnresolved, this.matchClassDecls));
        vector.add(this.getValidVersion(this.matchClassFilterFunctionsUnresolved, this.matchClassFilterFunctions));
        vector.add(this.getValidVersion(this.matchTypesIteratedUnresolved, this.matchTypesIterated));
        vector.add(this.getValidVersion(this.functionsUnresolved, this.functions));
        vector.add(this.getValidVersion(this.proceduresUnresolved, this.procedures));
        vector.add(this.getValidVersion(this.sequencesUnresolved, this.sequences));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("subpatterns");
        vector.add("actions");
        vector.add("match types");
        vector.add("filter functions");
        vector.add("match classes");
        vector.add("match class filter functions");
        vector.add("match types iterated");
        vector.add("functions");
        vector.add("procedures");
        vector.add("sequences");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.subpatterns = subpatternsResolver.resolve(this.subpatternsUnresolved, this);
        this.actions = actionsResolver.resolve(this.actionsUnresolved, this);
        this.matchTypes = matchTypesResolver.resolve(this.matchTypesUnresolved, this);
        this.filterFunctions = filterFunctionsResolver.resolve(this.filterFunctionsUnresolved, this);
        this.matchClassDecls = matchClassesResolver.resolve(this.matchClassesUnresolved, this);
        this.matchClassFilterFunctions = matchClassFilterFunctionsResolver.resolve(this.matchClassFilterFunctionsUnresolved, this);
        this.matchTypesIterated = matchTypesIteratedResolver.resolve(this.matchTypesIteratedUnresolved, this);
        this.functions = functionsResolver.resolve(this.functionsUnresolved, this);
        this.procedures = proceduresResolver.resolve(this.proceduresUnresolved, this);
        this.sequences = sequencesResolver.resolve(this.sequencesUnresolved, this);
        return this.subpatterns != null && this.actions != null && this.matchTypes != null && this.filterFunctions != null && this.matchClassDecls != null && this.matchClassFilterFunctions != null && this.matchTypesIterated != null && this.functions != null && this.procedures != null && this.sequences != null;
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = true;
        for (SubpatternDeclNode declNode : this.subpatterns.getChildren()) {
            bl &= UnitNode.checkStatementsLHS(declNode, declNode.pattern);
            if (declNode.right == null) continue;
            bl &= UnitNode.checkStatementsRHS(declNode, declNode.right.patternGraph);
        }
        for (ActionDeclNode actionDeclNode : this.actions.getChildren()) {
            bl &= UnitNode.checkStatementsLHS(actionDeclNode, actionDeclNode.pattern);
            if (!(actionDeclNode instanceof RuleDeclNode)) continue;
            RuleDeclNode ruleDeclNode = (RuleDeclNode)actionDeclNode;
            bl &= UnitNode.checkStatementsRHS(actionDeclNode, ruleDeclNode.right.patternGraph);
        }
        for (FilterFunctionDeclNode filterFunctionDeclNode : this.filterFunctions.getChildren()) {
            if (filterFunctionDeclNode.evalStatements == null) continue;
            bl &= EvalStatementNode.checkStatements(true, filterFunctionDeclNode, null, filterFunctionDeclNode.evalStatements, true);
        }
        for (MatchClassFilterFunctionDeclNode matchClassFilterFunctionDeclNode : this.matchClassFilterFunctions.getChildren()) {
            if (matchClassFilterFunctionDeclNode.evalStatements == null) continue;
            bl &= EvalStatementNode.checkStatements(true, matchClassFilterFunctionDeclNode, null, matchClassFilterFunctionDeclNode.evalStatements, true);
        }
        for (FunctionDeclNode functionDeclNode : this.functions.getChildren()) {
            bl &= EvalStatementNode.checkStatements(true, functionDeclNode, null, functionDeclNode.evalStatements, true);
        }
        for (ProcedureDeclNode procedureDeclNode : this.procedures.getChildren()) {
            bl &= EvalStatementNode.checkStatements(false, procedureDeclNode, null, procedureDeclNode.evalStatements, true);
        }
        return bl;
    }

    public PackageActionType getPackage() {
        return this.checkIR(PackageActionType.class);
    }

    @Override
    protected IR constructIR() {
        Base base;
        Ident ident = this.getIdentNode().checkIR(Ident.class);
        PackageActionType packageActionType = new PackageActionType(ident);
        for (SubpatternDeclNode baseNode : this.subpatterns.getChildren()) {
            base = baseNode.getMatcher();
            ((Rule)base).setPackageContainedIn(ident.toString());
            packageActionType.addSubpatternRule((Rule)base);
        }
        for (ActionDeclNode actionDeclNode : this.actions.getChildren()) {
            base = actionDeclNode.getMatcher();
            ((Rule)base).setPackageContainedIn(ident.toString());
            packageActionType.addActionRule((Rule)base);
        }
        for (MatchTypeActionNode matchTypeActionNode : this.matchTypes.getChildren()) {
            base = matchTypeActionNode.getMatchType();
            ((MatchType)base).setPackageContainedIn(ident.toString());
        }
        for (FilterFunctionDeclNode filterFunctionDeclNode : this.filterFunctions.getChildren()) {
            base = filterFunctionDeclNode.getFilterFunction();
            ((FilterFunction)base).setPackageContainedIn(ident.toString());
            packageActionType.addFilterFunction((FilterFunction)base);
        }
        for (TypeDeclNode typeDeclNode : this.matchClassDecls.getChildren()) {
            base = (DefinedMatchTypeNode)typeDeclNode.getDeclType();
            DefinedMatchType definedMatchType = ((DefinedMatchTypeNode)base).getDefinedMatchType();
            definedMatchType.setPackageContainedIn(ident.toString());
            packageActionType.addMatchClass(definedMatchType);
        }
        for (MatchClassFilterFunctionDeclNode matchClassFilterFunctionDeclNode : this.matchClassFilterFunctions.getChildren()) {
            base = matchClassFilterFunctionDeclNode.getMatchClassFilterFunction();
            ((MatchClassFilterFunction)base).setPackageContainedIn(ident.toString());
            packageActionType.addMatchClassFilterFunction((MatchClassFilterFunction)base);
        }
        for (MatchTypeIteratedNode matchTypeIteratedNode : this.matchTypesIterated.getChildren()) {
            base = matchTypeIteratedNode.getMatchTypeIterated();
            ((MatchType)base).setPackageContainedIn(ident.toString());
        }
        for (FunctionDeclNode functionDeclNode : this.functions.getChildren()) {
            base = functionDeclNode.getFunction();
            ((Function)base).setPackageContainedIn(ident.toString());
            packageActionType.addFunction((Function)base);
        }
        for (ProcedureDeclNode procedureDeclNode : this.procedures.getChildren()) {
            base = procedureDeclNode.getProcedure();
            ((Procedure)base).setPackageContainedIn(ident.toString());
            packageActionType.addProcedure((Procedure)base);
        }
        for (SequenceDeclNode sequenceDeclNode : this.sequences.getChildren()) {
            base = sequenceDeclNode.getSequence();
            ((Sequence)base).setPackageContainedIn(ident.toString());
            packageActionType.addSequence((Sequence)base);
        }
        return packageActionType;
    }

    @Override
    public String toString() {
        return "package " + this.getIdentNode();
    }

    public static String getKindStr() {
        return "package";
    }

    static {
        PackageActionTypeNode.setName(PackageActionTypeNode.class, "package in actions type");
        subpatternsResolver = new CollectResolver<SubpatternDeclNode>(new DeclarationResolver<SubpatternDeclNode>(SubpatternDeclNode.class));
        actionsResolver = new CollectResolver<ActionDeclNode>(new DeclarationResolver<ActionDeclNode>(ActionDeclNode.class));
        matchTypesResolver = new CollectResolver<MatchTypeActionNode>(new DeclarationTypeResolver<MatchTypeActionNode>(MatchTypeActionNode.class));
        filterFunctionsResolver = new CollectResolver<FilterFunctionDeclNode>(new DeclarationResolver<FilterFunctionDeclNode>(FilterFunctionDeclNode.class));
        matchClassesResolver = new CollectResolver<TypeDeclNode>(new DeclarationResolver<TypeDeclNode>(TypeDeclNode.class));
        matchClassFilterFunctionsResolver = new CollectResolver<MatchClassFilterFunctionDeclNode>(new DeclarationResolver<MatchClassFilterFunctionDeclNode>(MatchClassFilterFunctionDeclNode.class));
        matchTypesIteratedResolver = new CollectResolver<MatchTypeIteratedNode>(new DeclarationTypeResolver<MatchTypeIteratedNode>(MatchTypeIteratedNode.class));
        functionsResolver = new CollectResolver<FunctionDeclNode>(new DeclarationResolver<FunctionDeclNode>(FunctionDeclNode.class));
        proceduresResolver = new CollectResolver<ProcedureDeclNode>(new DeclarationResolver<ProcedureDeclNode>(ProcedureDeclNode.class));
        sequencesResolver = new CollectResolver<SequenceDeclNode>(new DeclarationResolver<SequenceDeclNode>(SequenceDeclNode.class));
    }
}

