/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.procenv;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.stmt.BuiltinProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.procenv.ExportProc;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ExportProcNode
extends BuiltinProcedureInvocationBaseNode {
    private ExprNode pathExpr;
    private ExprNode graphExpr;

    public ExportProcNode(Coords coords, ExprNode exprNode, ExprNode exprNode2) {
        super(coords);
        this.pathExpr = this.becomeParent(exprNode);
        this.graphExpr = this.becomeParent(exprNode2);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.pathExpr);
        if (this.graphExpr != null) {
            vector.add(this.graphExpr);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("path");
        if (this.graphExpr != null) {
            vector.add("graph");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode = this.pathExpr.getType();
        if (this.graphExpr != null) {
            TypeNode typeNode2 = this.graphExpr.getType();
            if (!typeNode2.equals(BasicTypeNode.graphType)) {
                this.reportError("The File::export procedure expects as 1. argument (subgraphToExport) a value of type graph (but is given a value of type " + typeNode2.toStringWithDeclarationCoords() + ").");
                return false;
            }
            if (!typeNode.equals(BasicTypeNode.stringType)) {
                this.reportError("The File::export procedure expects as 2. argument (filePath) a value of type string (but is given a value of type " + typeNode.toStringWithDeclarationCoords() + ").");
                return false;
            }
        } else if (!typeNode.equals(BasicTypeNode.stringType)) {
            this.reportError("The File::export procedure expects as argument (filePath) a value of type string (but is given a value of type " + typeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        this.pathExpr = this.pathExpr.evaluate();
        if (this.graphExpr != null) {
            this.graphExpr = this.graphExpr.evaluate();
        }
        return new ExportProc(this.pathExpr.checkIR(Expression.class), this.graphExpr != null ? this.graphExpr.checkIR(Expression.class) : null);
    }

    static {
        ExportProcNode.setName(ExportProcNode.class, "export procedure");
    }
}

