/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.procenv;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.stmt.BuiltinProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public abstract class DebugProcNode
extends BuiltinProcedureInvocationBaseNode {
    protected CollectNode<ExprNode> exprs = this.becomeParent(this.exprs);

    public DebugProcNode(Coords coords) {
        super(coords);
    }

    public void addExpression(ExprNode exprNode) {
        this.exprs.addChild(exprNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<CollectNode<ExprNode>> vector = new Vector<CollectNode<ExprNode>>();
        vector.add(this.exprs);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("exprs");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        ExprNode exprNode = this.exprs.get(0);
        TypeNode typeNode = exprNode.getType();
        if (!typeNode.equals(BasicTypeNode.stringType)) {
            this.reportError("The " + this.shortSignature() + " procedure expects as argument (message) a value of type string (but is given a value of type " + typeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        return true;
    }

    protected abstract String shortSignature();

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    static {
        DebugProcNode.setName(DebugProcNode.class, "debug procedure");
    }
}

