/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.procenv;

import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.stmt.procenv.DebugProcNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.procenv.DebugHighlightProc;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Vector;

public class DebugHighlightProcNode
extends DebugProcNode {
    public DebugHighlightProcNode(Coords coords) {
        super(coords);
    }

    @Override
    protected boolean checkLocal() {
        int n = 0;
        for (ExprNode exprNode : this.exprs.getChildren()) {
            TypeNode typeNode = exprNode.getType();
            if (n % 2 == 0 && !typeNode.equals(BasicTypeNode.stringType)) {
                this.reportError("The " + this.shortSignature() + " procedure expects as " + n + ". argument a value of type string (a message followed by a sequence of (value, annotation for the value)* must be given) (but is given a value of type " + typeNode.toStringWithDeclarationCoords() + ").");
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    protected String shortSignature() {
        return "Debug::highlight()";
    }

    @Override
    protected IR constructIR() {
        Vector<Expression> vector = new Vector<Expression>();
        for (ExprNode exprNode : this.exprs.getChildren()) {
            exprNode = exprNode.evaluate();
            vector.add(exprNode.checkIR(Expression.class));
        }
        return new DebugHighlightProc(vector);
    }

    static {
        DebugHighlightProcNode.setName(DebugHighlightProcNode.class, "debug highlight procedure");
    }
}

