/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.procenv;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.stmt.BuiltinProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Constant;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.procenv.AssertProc;
import de.unika.ipd.grgen.ir.type.Type;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class AssertProcNode
extends BuiltinProcedureInvocationBaseNode {
    private CollectNode<ExprNode> exprs = this.becomeParent(this.exprs);
    boolean isAlways;

    public AssertProcNode(Coords coords, boolean bl) {
        super(coords);
        this.isAlways = bl;
    }

    public void addExpression(ExprNode exprNode) {
        this.exprs.addChild(exprNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<CollectNode<ExprNode>> vector = new Vector<CollectNode<ExprNode>>();
        vector.add(this.exprs);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("exprs");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        ExprNode exprNode;
        TypeNode typeNode;
        ExprNode exprNode2 = this.exprs.get(0);
        TypeNode typeNode2 = exprNode2.getType();
        if (!typeNode2.isEqual(BasicTypeNode.booleanType)) {
            exprNode2.reportError("The " + this.name() + " procedure expects as 1. argument (condition to assert on) a value of type boolean (but is given a value of type " + typeNode2.toStringWithDeclarationCoords() + ").");
            return false;
        }
        if (this.exprs.size() >= 2 && !(typeNode = (exprNode = this.exprs.get(1)).getType()).isEqual(BasicTypeNode.stringType)) {
            exprNode.reportError("The " + this.name() + " procedure expects as 2. argument (message) a value of type string (but is given a value of type " + typeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        return true;
    }

    private String name() {
        return this.isAlways ? "assertAlways" : "assert";
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        Vector<Expression> vector = new Vector<Expression>();
        for (ExprNode exprNode : this.exprs.getChildren()) {
            exprNode = exprNode.evaluate();
            vector.add(exprNode.checkIR(Expression.class));
        }
        if (this.exprs.size() == 1) {
            vector.add(new Constant(BasicTypeNode.stringType.checkIR(Type.class), AssertProcNode.escapeBackslashAndDoubleQuotes(this.getCoords().toString())));
        }
        return new AssertProc(vector, this.isAlways);
    }

    protected static String escapeBackslashAndDoubleQuotes(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    static {
        AssertProcNode.setName(AssertProcNode.class, "assert procedure");
    }
}

