/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.map;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.QualIdentNode;
import de.unika.ipd.grgen.ast.stmt.map.MapProcedureMethodInvocationBaseNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.MapTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.map.MapRemoveItem;
import de.unika.ipd.grgen.ir.stmt.map.MapVarRemoveItem;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class MapRemoveItemNode
extends MapProcedureMethodInvocationBaseNode {
    private ExprNode keyExpr;

    public MapRemoveItemNode(Coords coords, QualIdentNode qualIdentNode, ExprNode exprNode) {
        super(coords, qualIdentNode);
        this.keyExpr = this.becomeParent(exprNode);
    }

    public MapRemoveItemNode(Coords coords, VarDeclNode varDeclNode, ExprNode exprNode) {
        super(coords, varDeclNode);
        this.keyExpr = this.becomeParent(exprNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.target != null ? this.target : this.targetVar);
        vector.add(this.keyExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("target");
        vector.add("keyExpr");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        MapTypeNode mapTypeNode = this.getTargetType();
        if (this.target != null) {
            TypeNode typeNode = mapTypeNode.keyType;
            TypeNode typeNode2 = this.keyExpr.getType();
            if (!typeNode2.isEqual(typeNode)) {
                ExprNode exprNode = this.keyExpr;
                this.keyExpr = this.becomeParent(this.keyExpr.adjustType(typeNode, this.getCoords()));
                if (this.keyExpr == ConstNode.getInvalid()) {
                    exprNode.reportError("The map rem item procedure expects as argument (key) a value of type " + typeNode.toStringWithDeclarationCoords() + " (but is given a value of type " + typeNode2.toStringWithDeclarationCoords() + ").");
                    return false;
                }
            }
            return true;
        }
        TypeNode typeNode = mapTypeNode.keyType;
        return this.checkType(this.keyExpr, typeNode, "map rem item procedure", "key");
    }

    @Override
    protected IR constructIR() {
        this.keyExpr = this.keyExpr.evaluate();
        if (this.target != null) {
            return new MapRemoveItem(this.target.checkIR(Qualification.class), this.keyExpr.checkIR(Expression.class));
        }
        return new MapVarRemoveItem(this.targetVar.checkIR(Variable.class), this.keyExpr.checkIR(Expression.class));
    }

    static {
        MapRemoveItemNode.setName(MapRemoveItemNode.class, "map remove item statement");
    }
}

