/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.invocation;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.IdentExprNode;
import de.unika.ipd.grgen.ast.expr.QualIdentNode;
import de.unika.ipd.grgen.ast.model.type.ExternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.stmt.BuiltinProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.array.ArrayAddAllNode;
import de.unika.ipd.grgen.ast.stmt.array.ArrayAddItemNode;
import de.unika.ipd.grgen.ast.stmt.array.ArrayClearNode;
import de.unika.ipd.grgen.ast.stmt.array.ArrayRemoveItemNode;
import de.unika.ipd.grgen.ast.stmt.deque.DequeAddItemNode;
import de.unika.ipd.grgen.ast.stmt.deque.DequeClearNode;
import de.unika.ipd.grgen.ast.stmt.deque.DequeRemoveItemNode;
import de.unika.ipd.grgen.ast.stmt.invocation.ExternalProcedureMethodInvocationNode;
import de.unika.ipd.grgen.ast.stmt.invocation.ProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.stmt.invocation.ProcedureMethodInvocationNode;
import de.unika.ipd.grgen.ast.stmt.invocation.ProcedureOrBuiltinProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.stmt.map.MapAddItemNode;
import de.unika.ipd.grgen.ast.stmt.map.MapClearNode;
import de.unika.ipd.grgen.ast.stmt.map.MapRemoveItemNode;
import de.unika.ipd.grgen.ast.stmt.set.SetAddAllNode;
import de.unika.ipd.grgen.ast.stmt.set.SetAddItemNode;
import de.unika.ipd.grgen.ast.stmt.set.SetClearNode;
import de.unika.ipd.grgen.ast.stmt.set.SetRemoveItemNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.type.container.DequeTypeNode;
import de.unika.ipd.grgen.ast.type.container.MapTypeNode;
import de.unika.ipd.grgen.ast.type.container.SetTypeNode;
import de.unika.ipd.grgen.ast.util.ResolvingEnvironment;
import de.unika.ipd.grgen.ir.IR;
import java.util.Collection;
import java.util.Vector;

public class ProcedureMethodInvocationDecisionNode
extends ProcedureInvocationBaseNode {
    private BaseNode target;
    private IdentNode methodIdent;
    private ProcedureOrBuiltinProcedureInvocationBaseNode result;

    public ProcedureMethodInvocationDecisionNode(BaseNode baseNode, IdentNode identNode, CollectNode<ExprNode> collectNode, int n) {
        super(identNode.getCoords(), collectNode, n);
        this.target = this.becomeParent(baseNode);
        this.methodIdent = this.becomeParent(identNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.target);
        vector.add(this.arguments);
        if (this.isResolved()) {
            vector.add(this.result);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("target");
        vector.add("params");
        if (this.isResolved()) {
            vector.add("result");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (!this.target.resolve()) {
            return false;
        }
        String string = this.methodIdent.toString();
        VarDeclNode varDeclNode = null;
        QualIdentNode qualIdentNode = null;
        TypeNode typeNode = null;
        if (this.target instanceof QualIdentNode) {
            qualIdentNode = (QualIdentNode)this.target;
            typeNode = qualIdentNode.getDecl().getDeclType();
        } else if (((IdentExprNode)this.target).decl instanceof VarDeclNode) {
            varDeclNode = (VarDeclNode)((IdentExprNode)this.target).decl;
            typeNode = varDeclNode.getDeclType();
        } else {
            typeNode = ((IdentExprNode)this.target).getType();
        }
        ResolvingEnvironment resolvingEnvironment = new ResolvingEnvironment(null, error, this.getCoords());
        if (typeNode instanceof MapTypeNode) {
            this.result = ProcedureMethodInvocationDecisionNode.decideMap(qualIdentNode, varDeclNode, string, this.arguments, resolvingEnvironment);
        } else if (typeNode instanceof SetTypeNode) {
            this.result = ProcedureMethodInvocationDecisionNode.decideSet(qualIdentNode, varDeclNode, string, this.arguments, resolvingEnvironment);
        } else if (typeNode instanceof ArrayTypeNode) {
            this.result = ProcedureMethodInvocationDecisionNode.decideArray(qualIdentNode, varDeclNode, string, this.arguments, resolvingEnvironment);
        } else if (typeNode instanceof DequeTypeNode) {
            this.result = ProcedureMethodInvocationDecisionNode.decideDeque(qualIdentNode, varDeclNode, string, this.arguments, resolvingEnvironment);
        } else if (typeNode instanceof InheritanceTypeNode && !(typeNode instanceof ExternalObjectTypeNode)) {
            this.result = new ProcedureMethodInvocationNode(((IdentExprNode)this.target).getIdent(), this.methodIdent, this.arguments, this.context);
            this.result.resolve();
        } else if (typeNode instanceof ExternalObjectTypeNode) {
            this.result = qualIdentNode != null ? new ExternalProcedureMethodInvocationNode(qualIdentNode, this.methodIdent, (CollectNode<ExprNode>)this.arguments, this.context) : new ExternalProcedureMethodInvocationNode(varDeclNode, this.methodIdent, (CollectNode<ExprNode>)this.arguments, this.context);
            this.result.resolve();
        } else {
            this.reportError(typeNode.getTypeName() + " does not have any procedure methods.");
        }
        return this.result != null;
    }

    private static BuiltinProcedureInvocationBaseNode decideMap(QualIdentNode qualIdentNode, VarDeclNode varDeclNode, String string, CollectNode<ExprNode> collectNode, ResolvingEnvironment resolvingEnvironment) {
        switch (string) {
            case "add": {
                if (collectNode.size() != 2) {
                    resolvingEnvironment.reportError("map<S,T>.add(key, value) expects 2 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (qualIdentNode != null) {
                    return new MapAddItemNode(resolvingEnvironment.getCoords(), qualIdentNode, collectNode.get(0), collectNode.get(1));
                }
                return new MapAddItemNode(resolvingEnvironment.getCoords(), varDeclNode, collectNode.get(0), collectNode.get(1));
            }
            case "rem": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("map<S,T>.rem(key) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (qualIdentNode != null) {
                    return new MapRemoveItemNode(resolvingEnvironment.getCoords(), qualIdentNode, collectNode.get(0));
                }
                return new MapRemoveItemNode(resolvingEnvironment.getCoords(), varDeclNode, collectNode.get(0));
            }
            case "clear": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("map<S,T>.clear() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (qualIdentNode != null) {
                    return new MapClearNode(resolvingEnvironment.getCoords(), qualIdentNode);
                }
                return new MapClearNode(resolvingEnvironment.getCoords(), varDeclNode);
            }
        }
        resolvingEnvironment.reportError("map<S,T> does not have a procedure method named " + string + " (available are add, rem, clear).");
        return null;
    }

    private static BuiltinProcedureInvocationBaseNode decideSet(QualIdentNode qualIdentNode, VarDeclNode varDeclNode, String string, CollectNode<ExprNode> collectNode, ResolvingEnvironment resolvingEnvironment) {
        switch (string) {
            case "add": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("set<T>.add(value) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (qualIdentNode != null) {
                    return new SetAddItemNode(resolvingEnvironment.getCoords(), qualIdentNode, collectNode.get(0));
                }
                return new SetAddItemNode(resolvingEnvironment.getCoords(), varDeclNode, collectNode.get(0));
            }
            case "addAll": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("set<T>.addAll(set<T>) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (qualIdentNode != null) {
                    resolvingEnvironment.reportError("set<T>.addAll(set<T>) is not available on attributes (only variables; so you have to copy-assign or have to use a loop).");
                } else {
                    return new SetAddAllNode(resolvingEnvironment.getCoords(), varDeclNode, collectNode.get(0));
                }
            }
            case "rem": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("set<T>.rem(value) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (qualIdentNode != null) {
                    return new SetRemoveItemNode(resolvingEnvironment.getCoords(), qualIdentNode, collectNode.get(0));
                }
                return new SetRemoveItemNode(resolvingEnvironment.getCoords(), varDeclNode, collectNode.get(0));
            }
            case "clear": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("set<T>.clear() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (qualIdentNode != null) {
                    return new SetClearNode(resolvingEnvironment.getCoords(), qualIdentNode);
                }
                return new SetClearNode(resolvingEnvironment.getCoords(), varDeclNode);
            }
        }
        resolvingEnvironment.reportError("set<T> does not have a procedure method named " + string + " (available are add, addAll, rem, clear).");
        return null;
    }

    private static BuiltinProcedureInvocationBaseNode decideArray(QualIdentNode qualIdentNode, VarDeclNode varDeclNode, String string, CollectNode<ExprNode> collectNode, ResolvingEnvironment resolvingEnvironment) {
        switch (string) {
            case "add": {
                if (collectNode.size() != 1 && collectNode.size() != 2) {
                    resolvingEnvironment.reportError("array<T>.add(value)/array<T>.add(value, index) expects 1 or 2 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (qualIdentNode != null) {
                    return new ArrayAddItemNode(resolvingEnvironment.getCoords(), qualIdentNode, collectNode.get(0), collectNode.size() != 1 ? collectNode.get(1) : null);
                }
                return new ArrayAddItemNode(resolvingEnvironment.getCoords(), varDeclNode, collectNode.get(0), collectNode.size() != 1 ? collectNode.get(1) : null);
            }
            case "addAll": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("array<T>.addAll(array<T>) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (qualIdentNode != null) {
                    resolvingEnvironment.reportError("array<T>.addAll(array<T>) is not available on attributes (only variables; so you have to copy-assign or have to use a loop).");
                } else {
                    return new ArrayAddAllNode(resolvingEnvironment.getCoords(), varDeclNode, collectNode.get(0));
                }
            }
            case "rem": {
                if (collectNode.size() != 1 && collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.rem()/array<T>.rem(index) expects 0 or 1 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (qualIdentNode != null) {
                    return new ArrayRemoveItemNode(resolvingEnvironment.getCoords(), qualIdentNode, collectNode.size() != 0 ? collectNode.get(0) : null);
                }
                return new ArrayRemoveItemNode(resolvingEnvironment.getCoords(), varDeclNode, collectNode.size() != 0 ? collectNode.get(0) : null);
            }
            case "clear": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.clear() expects no arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (qualIdentNode != null) {
                    return new ArrayClearNode(resolvingEnvironment.getCoords(), qualIdentNode);
                }
                return new ArrayClearNode(resolvingEnvironment.getCoords(), varDeclNode);
            }
        }
        resolvingEnvironment.reportError("array<T> does not have a procedure method named " + string + " (available are add, addAll, rem, clear).");
        return null;
    }

    private static BuiltinProcedureInvocationBaseNode decideDeque(QualIdentNode qualIdentNode, VarDeclNode varDeclNode, String string, CollectNode<ExprNode> collectNode, ResolvingEnvironment resolvingEnvironment) {
        switch (string) {
            case "add": {
                if (collectNode.size() != 1 && collectNode.size() != 2) {
                    resolvingEnvironment.reportError("deque<T>.add(value)/deque<T>.add(value, index) expects 1 or 2 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (qualIdentNode != null) {
                    return new DequeAddItemNode(resolvingEnvironment.getCoords(), qualIdentNode, collectNode.get(0), collectNode.size() != 1 ? collectNode.get(1) : null);
                }
                return new DequeAddItemNode(resolvingEnvironment.getCoords(), varDeclNode, collectNode.get(0), collectNode.size() != 1 ? collectNode.get(1) : null);
            }
            case "rem": {
                if (collectNode.size() != 1 && collectNode.size() != 0) {
                    resolvingEnvironment.reportError("deque<T>.rem()/deque<T>.rem(index) expects 0 or 1 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (qualIdentNode != null) {
                    return new DequeRemoveItemNode(resolvingEnvironment.getCoords(), qualIdentNode, collectNode.size() != 0 ? collectNode.get(0) : null);
                }
                return new DequeRemoveItemNode(resolvingEnvironment.getCoords(), varDeclNode, collectNode.size() != 0 ? collectNode.get(0) : null);
            }
            case "clear": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("deque<T>.clear() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (qualIdentNode != null) {
                    return new DequeClearNode(resolvingEnvironment.getCoords(), qualIdentNode);
                }
                return new DequeClearNode(resolvingEnvironment.getCoords(), varDeclNode);
            }
        }
        resolvingEnvironment.reportError("deque<T> does not have a procedure method named " + string + " (available are add, rem, clear).");
        return null;
    }

    @Override
    protected boolean checkLocal() {
        if ((this.context & 0x80) == 0 && !(this.result instanceof ProcedureMethodInvocationNode) && !(this.result instanceof ExternalProcedureMethodInvocationNode) && this.target instanceof QualIdentNode) {
            this.reportError("A procedure method call (built-in-procedure-method " + this.methodIdent + ") is not allowed in function or pattern part context.");
            return false;
        }
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    public Vector<TypeNode> getType() {
        return this.result.getType();
    }

    public int getNumReturnTypes() {
        return this.result.getType().size();
    }

    public IdentNode getIdentNode() {
        return this.methodIdent;
    }

    @Override
    protected IR constructIR() {
        return this.result.getIR();
    }

    static {
        ProcedureMethodInvocationDecisionNode.setName(ProcedureMethodInvocationDecisionNode.class, "procedure method invocation decision statement");
    }
}

