/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.invocation;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.stmt.BuiltinProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.graph.GraphAddCopyEdgeProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.GraphAddCopyNodeProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.GraphAddEdgeProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.GraphAddNodeProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.GraphClearProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.GraphMergeProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.GraphRedirectSourceAndTargetProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.GraphRedirectSourceProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.GraphRedirectTargetProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.GraphRemoveProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.GraphRetypeProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.InsertCopyProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.InsertDefinedSubgraphProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.InsertInducedSubgraphProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.InsertProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.VAllocProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.VFreeNonResetProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.VFreeProcNode;
import de.unika.ipd.grgen.ast.stmt.graph.VResetProcNode;
import de.unika.ipd.grgen.ast.stmt.invocation.ProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.stmt.invocation.ProcedureOrBuiltinProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.stmt.procenv.AssertProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.EmitProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.GetEquivalentOrAddProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.RecordProcNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.executable.ProcedureTypeNode;
import de.unika.ipd.grgen.ast.util.ResolvingEnvironment;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.parser.ParserEnvironment;
import java.util.Collection;
import java.util.Vector;

public class ProcedureInvocationDecisionNode
extends ProcedureInvocationBaseNode {
    static TypeNode procedureTypeNode;
    protected IdentNode procedureIdent;
    protected BuiltinProcedureInvocationBaseNode result;
    ParserEnvironment env;

    public ProcedureInvocationDecisionNode(IdentNode identNode, CollectNode<ExprNode> collectNode, int n, ParserEnvironment parserEnvironment) {
        super(identNode.getCoords(), collectNode, n);
        this.procedureIdent = this.becomeParent(identNode);
        this.env = parserEnvironment;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.arguments);
        if (this.isResolved()) {
            vector.add(this.result);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("params");
        if (this.isResolved()) {
            vector.add("result");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        ResolvingEnvironment resolvingEnvironment = new ResolvingEnvironment(this.env, error, this.getCoords());
        this.result = ProcedureInvocationDecisionNode.decide(this.procedureIdent.toString(), this.arguments, resolvingEnvironment);
        return this.result != null;
    }

    private static BuiltinProcedureInvocationBaseNode decide(String string, CollectNode<ExprNode> collectNode, ResolvingEnvironment resolvingEnvironment) {
        switch (string) {
            case "add": {
                if (collectNode.size() == 1) {
                    return new GraphAddNodeProcNode(resolvingEnvironment.getCoords(), collectNode.get(0));
                }
                if (collectNode.size() == 3) {
                    return new GraphAddEdgeProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2));
                }
                resolvingEnvironment.reportError(string + "() expects 1 or 3 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "retype": {
                if (collectNode.size() == 2) {
                    return new GraphRetypeProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1));
                }
                resolvingEnvironment.reportError(string + "() expects 2 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "insert": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("insert(.) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new InsertProcNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "insertCopy": {
                if (collectNode.size() != 2) {
                    resolvingEnvironment.reportError("insertCopy(.,.) expects 2 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new InsertCopyProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1));
            }
            case "insertInduced": {
                if (collectNode.size() != 2) {
                    resolvingEnvironment.reportError("insertInduced(.,.) expects 2 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new InsertInducedSubgraphProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1));
            }
            case "insertDefined": {
                if (collectNode.size() != 2) {
                    resolvingEnvironment.reportError("insertDefined(.,.) expects 2 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new InsertDefinedSubgraphProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1));
            }
            case "valloc": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("valloc() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new VAllocProcNode(resolvingEnvironment.getCoords());
            }
            case "rem": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("rem(value) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new GraphRemoveProcNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "clear": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("clear() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new GraphClearProcNode(resolvingEnvironment.getCoords());
            }
            case "vfree": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("vfree(value) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new VFreeProcNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "vfreenonreset": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("vfreenonreset(value) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new VFreeNonResetProcNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "vreset": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("vreset(value) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new VResetProcNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "record": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("record(value) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new RecordProcNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "emit": {
                if (collectNode.size() >= 1) {
                    EmitProcNode emitProcNode = new EmitProcNode(resolvingEnvironment.getCoords(), false);
                    for (ExprNode exprNode : collectNode.getChildren()) {
                        emitProcNode.addExpression(exprNode);
                    }
                    return emitProcNode;
                }
                resolvingEnvironment.reportError("emit() expects at least one argument (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "emitdebug": {
                if (collectNode.size() >= 1) {
                    EmitProcNode emitProcNode = new EmitProcNode(resolvingEnvironment.getCoords(), true);
                    for (ExprNode exprNode : collectNode.getChildren()) {
                        emitProcNode.addExpression(exprNode);
                    }
                    return emitProcNode;
                }
                resolvingEnvironment.reportError("emitdebug() expects at least one argument (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "addCopy": {
                if (collectNode.size() == 1) {
                    return new GraphAddCopyNodeProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), true);
                }
                if (collectNode.size() == 3) {
                    return new GraphAddCopyEdgeProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), true);
                }
                resolvingEnvironment.reportError(string + "() expects 1 or 3 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "addClone": {
                if (collectNode.size() == 1) {
                    return new GraphAddCopyNodeProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), false);
                }
                if (collectNode.size() == 3) {
                    return new GraphAddCopyEdgeProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), false);
                }
                resolvingEnvironment.reportError(string + "() expects 1 or 3 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "merge": {
                if (collectNode.size() < 2 || collectNode.size() > 3) {
                    resolvingEnvironment.reportError("merge(target,source,oldSourceName) expects 2 or 3 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (collectNode.size() == 2) {
                    return new GraphMergeProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), null);
                }
                return new GraphMergeProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2));
            }
            case "redirectSource": {
                if (collectNode.size() < 2 || collectNode.size() > 3) {
                    resolvingEnvironment.reportError("redirectSource(edge,newSource,oldSourceName) expects 2 or 3 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (collectNode.size() == 2) {
                    return new GraphRedirectSourceProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), null);
                }
                return new GraphRedirectSourceProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2));
            }
            case "redirectTarget": {
                if (collectNode.size() < 2 || collectNode.size() > 3) {
                    resolvingEnvironment.reportError("redirectTarget(edge,newTarget,oldTargetName) expects 2 two or 3 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (collectNode.size() == 2) {
                    return new GraphRedirectTargetProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), null);
                }
                return new GraphRedirectTargetProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2));
            }
            case "redirectSourceAndTarget": {
                if (collectNode.size() != 3 && collectNode.size() != 5) {
                    resolvingEnvironment.reportError("redirectSourceAndTarget(edge,newSource,newTarget,oldSourceName,oldTargetName) expects 3 or 5 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (collectNode.size() == 3) {
                    return new GraphRedirectSourceAndTargetProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), null, null);
                }
                return new GraphRedirectSourceAndTargetProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), collectNode.get(3), collectNode.get(4));
            }
            case "getEquivalentOrAdd": {
                if (collectNode.size() != 2) {
                    resolvingEnvironment.reportError("getEquivalentOrAdd(graph, array<graph>) expects 2 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new GetEquivalentOrAddProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), true);
            }
            case "getEquivalentStructurallyOrAdd": {
                if (collectNode.size() != 2) {
                    resolvingEnvironment.reportError("getEquivalentStructurallyOrAdd(graph, array<graph>) expects 2 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new GetEquivalentOrAddProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), false);
            }
            case "assert": {
                if (collectNode.size() >= 1) {
                    AssertProcNode assertProcNode = new AssertProcNode(resolvingEnvironment.getCoords(), false);
                    for (ExprNode exprNode : collectNode.getChildren()) {
                        assertProcNode.addExpression(exprNode);
                    }
                    return assertProcNode;
                }
                resolvingEnvironment.reportError("assert() expects at least one argument (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "assertAlways": {
                if (collectNode.size() >= 1) {
                    AssertProcNode assertProcNode = new AssertProcNode(resolvingEnvironment.getCoords(), true);
                    for (ExprNode exprNode : collectNode.getChildren()) {
                        assertProcNode.addExpression(exprNode);
                    }
                    return assertProcNode;
                }
                resolvingEnvironment.reportError("assertAlways() expects at least one argument (given are " + collectNode.size() + " arguments).");
                return null;
            }
        }
        resolvingEnvironment.reportError("A procedure of name " + string + " is not known.");
        return null;
    }

    @Override
    protected boolean checkLocal() {
        if ((this.context & 0x80) == 0) {
            if (this.isEmitOrDebugProcedure()) {
                return true;
            }
            this.reportError("A procedure call (built-in-procedure " + this.procedureIdent + ") is not allowed in function or pattern part context.");
            return false;
        }
        return true;
    }

    public boolean isEmitOrDebugProcedure() {
        return this.isEmitProcedure() || this.isDebugProcedure();
    }

    protected boolean isEmitProcedure() {
        switch (this.procedureIdent.toString()) {
            case "emit": 
            case "emitdebug": {
                return true;
            }
        }
        return false;
    }

    protected boolean isDebugProcedure() {
        switch (this.procedureIdent.toString()) {
            case "assert": 
            case "assertAlways": {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    protected ProcedureOrBuiltinProcedureInvocationBaseNode getResult() {
        return this.result;
    }

    @Override
    public Vector<TypeNode> getType() {
        return this.result.getType();
    }

    public int getNumReturnTypes() {
        return this.result.getType().size();
    }

    public String getProcedureName() {
        return this.procedureIdent.toString();
    }

    @Override
    protected IR constructIR() {
        return this.result.getIR();
    }

    static {
        ProcedureInvocationDecisionNode.setName(ProcedureInvocationDecisionNode.class, "procedure invocation decision");
        procedureTypeNode = new ProcedureTypeNode();
    }
}

