/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.invocation;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.ScopeOwner;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ExternalProcedureDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.QualIdentNode;
import de.unika.ipd.grgen.ast.model.type.ExternalObjectTypeNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.invocation.ProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.ExternalProcedure;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.invocation.ExternalProcedureMethodInvocation;
import de.unika.ipd.grgen.ir.type.Type;
import java.util.Collection;
import java.util.Vector;

public class ExternalProcedureMethodInvocationNode
extends ProcedureInvocationBaseNode {
    VarDeclNode targetVar = null;
    QualIdentNode targetQual = null;
    IdentNode externalProcedureUnresolved;
    ExternalProcedureDeclNode externalProcedureDecl;
    private static final DeclarationResolver<ExternalProcedureDeclNode> resolver;

    public ExternalProcedureMethodInvocationNode(VarDeclNode varDeclNode, IdentNode identNode, CollectNode<ExprNode> collectNode, int n) {
        super(identNode.getCoords(), collectNode, n);
        this.targetVar = this.becomeParent(varDeclNode);
        this.externalProcedureUnresolved = this.becomeParent(identNode);
    }

    public ExternalProcedureMethodInvocationNode(QualIdentNode qualIdentNode, IdentNode identNode, CollectNode<ExprNode> collectNode, int n) {
        super(identNode.getCoords(), collectNode, n);
        this.targetQual = this.becomeParent(qualIdentNode);
        this.externalProcedureUnresolved = this.becomeParent(identNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.targetQual != null ? this.targetQual : this.targetVar);
        vector.add(this.getValidVersion(this.externalProcedureUnresolved, this.externalProcedureDecl));
        vector.add(this.arguments);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("target");
        vector.add("external procedure");
        vector.add("arguments");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        TypeNode typeNode;
        boolean bl = true;
        TypeNode typeNode2 = typeNode = this.targetVar != null ? this.targetVar.getDeclType() : this.targetQual.getDecl().getDeclType();
        if (typeNode instanceof ExternalObjectTypeNode) {
            if (typeNode instanceof ScopeOwner) {
                ScopeOwner scopeOwner = (ScopeOwner)((Object)typeNode);
                scopeOwner.fixupDefinition(this.externalProcedureUnresolved);
                this.externalProcedureDecl = (ExternalProcedureDeclNode)resolver.resolve(this.externalProcedureUnresolved, this);
                if (this.externalProcedureDecl == null) {
                    this.externalProcedureUnresolved.reportError("Unknown external procedure method called. (Maybe a misspelled procedure name? Or is a function call intended? An assignment target within parenthesis denotes a procedure call, as in (var) = " + (this.targetVar != null ? this.targetVar : this.targetQual) + "." + this.externalProcedureUnresolved + "(...)).");
                    return false;
                }
                bl = this.externalProcedureDecl != null && bl;
            } else {
                this.reportError("Left hand side of '.' does not own a scope (type " + typeNode.toStringWithDeclarationCoords() + ").");
                bl = false;
            }
        } else {
            this.reportError("Left hand side of '.' is not an external type (type " + typeNode.toStringWithDeclarationCoords() + ").");
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        if ((this.context & 0x80) == 0) {
            this.reportError("External procedure method call not allowed in function or pattern part context (attempted on " + this.externalProcedureUnresolved + ").");
            return false;
        }
        return this.checkSignatureAdhered(this.externalProcedureDecl, this.externalProcedureUnresolved, true);
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    public Vector<TypeNode> getType() {
        assert (this.isResolved());
        return this.externalProcedureDecl.getResultTypes();
    }

    public int getNumReturnTypes() {
        return this.externalProcedureDecl.resultTypesCollectNode.size();
    }

    @Override
    protected IR constructIR() {
        ExternalProcedureMethodInvocation externalProcedureMethodInvocation = this.targetQual != null ? new ExternalProcedureMethodInvocation(this.targetQual.checkIR(Qualification.class), this.externalProcedureDecl.checkIR(ExternalProcedure.class)) : new ExternalProcedureMethodInvocation(this.targetVar.checkIR(Variable.class), this.externalProcedureDecl.checkIR(ExternalProcedure.class));
        for (BaseNode baseNode : this.arguments.getChildren()) {
            baseNode = ((ExprNode)baseNode).evaluate();
            externalProcedureMethodInvocation.addArgument(baseNode.checkIR(Expression.class));
        }
        for (BaseNode baseNode : this.externalProcedureDecl.resultTypesCollectNode.getChildren()) {
            externalProcedureMethodInvocation.addReturnType(baseNode.checkIR(Type.class));
        }
        return externalProcedureMethodInvocation;
    }

    static {
        ExternalProcedureMethodInvocationNode.setName(ExternalProcedureMethodInvocationNode.class, "external procedure method invocation");
        resolver = new DeclarationResolver<ExternalProcedureDeclNode>(ExternalProcedureDeclNode.class);
    }
}

