/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.stmt.BuiltinProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.graph.GraphRemoveProc;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class GraphRemoveProcNode
extends BuiltinProcedureInvocationBaseNode {
    private ExprNode entityExpr;

    public GraphRemoveProcNode(Coords coords, ExprNode exprNode) {
        super(coords);
        this.entityExpr = exprNode;
        this.becomeParent(exprNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.entityExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("entity");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode = this.entityExpr.getType();
        if (typeNode instanceof EdgeTypeNode) {
            return true;
        }
        if (typeNode instanceof NodeTypeNode) {
            return true;
        }
        this.reportError("The rem procedure expects as argument (entity) a value of type Node or Edge (but is given a value of type " + typeNode.toStringWithDeclarationCoords() + ").");
        return false;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        this.entityExpr = this.entityExpr.evaluate();
        return new GraphRemoveProc(this.entityExpr.checkIR(Expression.class));
    }

    static {
        GraphRemoveProcNode.setName(GraphRemoveProcNode.class, "graph remove procedure");
    }
}

