/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.stmt.BuiltinProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.graph.GraphRedirectTargetProc;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class GraphRedirectTargetProcNode
extends BuiltinProcedureInvocationBaseNode {
    private ExprNode edgeExpr;
    private ExprNode newTargetExpr;
    private ExprNode oldTargetNameExpr;

    public GraphRedirectTargetProcNode(Coords coords, ExprNode exprNode, ExprNode exprNode2, ExprNode exprNode3) {
        super(coords);
        this.edgeExpr = exprNode;
        this.becomeParent(exprNode);
        this.newTargetExpr = exprNode2;
        this.becomeParent(exprNode2);
        this.oldTargetNameExpr = exprNode3;
        if (exprNode3 != null) {
            this.becomeParent(exprNode3);
        }
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.edgeExpr);
        vector.add(this.newTargetExpr);
        if (this.oldTargetNameExpr != null) {
            vector.add(this.oldTargetNameExpr);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("edge");
        vector.add("newTarget");
        if (this.oldTargetNameExpr != null) {
            vector.add("oldTargetName");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode;
        TypeNode typeNode2 = this.edgeExpr.getType();
        if (!(typeNode2 instanceof EdgeTypeNode)) {
            this.reportError("The redirectTarget procedure expects as 1. argument (edgeToBeRedirected) a value of type Edge (but is given a value of type " + typeNode2.toStringWithDeclarationCoords() + ").");
            return false;
        }
        TypeNode typeNode3 = this.newTargetExpr.getType();
        if (!(typeNode3 instanceof NodeTypeNode)) {
            this.reportError("The redirectTarget procedure expects as 2. argument (newTargetNode) a value of type Node (but is given a value of type " + typeNode3.toStringWithDeclarationCoords() + ").");
            return false;
        }
        if (this.oldTargetNameExpr != null && !(typeNode = this.oldTargetNameExpr.getType()).equals(BasicTypeNode.stringType)) {
            this.reportError("The redirectTarget procedure expects as 3. argument (oldTargetName) a value of type string (but is given a value of type " + typeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        this.edgeExpr = this.edgeExpr.evaluate();
        this.newTargetExpr = this.newTargetExpr.evaluate();
        if (this.oldTargetNameExpr != null) {
            this.oldTargetNameExpr = this.oldTargetNameExpr.evaluate();
        }
        return new GraphRedirectTargetProc(this.edgeExpr.checkIR(Expression.class), this.newTargetExpr.checkIR(Expression.class), this.oldTargetNameExpr != null ? this.oldTargetNameExpr.checkIR(Expression.class) : null);
    }

    static {
        GraphRedirectTargetProcNode.setName(GraphRedirectTargetProcNode.class, "graph redirect target procedure");
    }
}

