/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.decl.IndexDeclNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.graph.ForIndexAccessNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.model.Index;
import de.unika.ipd.grgen.ir.pattern.IndexAccessOrdering;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.stmt.graph.ForIndexAccessOrdering;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ForIndexAccessOrderingYieldNode
extends ForIndexAccessNode {
    private boolean ascending;
    private OperatorDeclNode.Operator comp;
    private ExprNode expr;
    private OperatorDeclNode.Operator comp2;
    private ExprNode expr2;
    private static DeclarationResolver<IndexDeclNode> indexResolver;

    public ForIndexAccessOrderingYieldNode(Coords coords, BaseNode baseNode, int n, boolean bl, IdentNode identNode, OperatorDeclNode.Operator operator, ExprNode exprNode, OperatorDeclNode.Operator operator2, ExprNode exprNode2, PatternGraphLhsNode patternGraphLhsNode, CollectNode<EvalStatementNode> collectNode) {
        super(coords, baseNode, n, identNode, patternGraphLhsNode, collectNode);
        this.ascending = bl;
        this.comp = operator;
        this.expr = exprNode;
        this.becomeParent(this.expr);
        this.comp2 = operator2;
        this.expr2 = exprNode2;
        this.becomeParent(this.expr);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.iterationVariableUnresolved, this.iterationVariable));
        vector.add(this.getValidVersion(this.indexUnresolved, this.index));
        if (this.expr != null) {
            vector.add(this.expr);
        }
        if (this.expr2 != null) {
            vector.add(this.expr2);
        }
        vector.add(this.statements);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("iterVar");
        vector.add("index");
        if (this.expr != null) {
            vector.add("expression");
        }
        if (this.expr2 != null) {
            vector.add("expression2");
        }
        vector.add("loopedStatements");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = true;
        if (!this.resolveIterationVariable("index access ordering")) {
            bl = false;
        }
        this.index = (IndexDeclNode)indexResolver.resolve(this.indexUnresolved, this);
        bl &= this.index != null;
        if (this.expr != null) {
            bl &= this.expr.resolve();
        }
        if (this.expr2 != null) {
            bl &= this.expr2.resolve();
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode;
        TypeNode typeNode2;
        if (!this.checkIterationVariable("index access ordering")) {
            return false;
        }
        boolean bl = true;
        if (this.expr != null) {
            TypeNode typeNode3;
            typeNode2 = this.index.getExpectedAccessType();
            typeNode = this.expr.getType();
            if (!typeNode.isCompatibleTo(typeNode2)) {
                this.reportError("Cannot convert type used in accessing index from " + typeNode.toStringWithDeclarationCoords() + " to the expected " + typeNode2.toStringWithDeclarationCoords() + " in index access loop (on " + this.indexUnresolved + ").");
                return false;
            }
            if (this.expr2 != null && !(typeNode3 = this.expr2.getType()).isCompatibleTo(typeNode2)) {
                this.reportError("Cannot convert type used in accessing index from " + typeNode3.toStringWithDeclarationCoords() + " to the expected " + typeNode2.toStringWithDeclarationCoords() + " in index access loop (on " + this.indexUnresolved + ").");
                return false;
            }
        }
        typeNode2 = this.iterationVariable.getDeclType();
        typeNode = this.index.getType();
        if (!typeNode.isCompatibleTo(typeNode2) && !typeNode2.isCompatibleTo(typeNode)) {
            this.reportError("Cannot convert index type from " + typeNode.toStringWithDeclarationCoords() + " to the expected " + typeNode2.toStringWithDeclarationCoords() + " in index access loop (on " + this.indexUnresolved + ").");
            return false;
        }
        if (!(this.comp != OperatorDeclNode.Operator.LT && this.comp != OperatorDeclNode.Operator.LE || this.expr2 == null || this.comp2 != OperatorDeclNode.Operator.LT && this.comp2 != OperatorDeclNode.Operator.LE)) {
            this.reportError("The index access loop does not support two upper bounds (given when accessing " + this.indexUnresolved + ").");
            return false;
        }
        if (!(this.comp != OperatorDeclNode.Operator.GT && this.comp != OperatorDeclNode.Operator.GE || this.expr2 == null || this.comp2 != OperatorDeclNode.Operator.GT && this.comp2 != OperatorDeclNode.Operator.GE)) {
            this.reportError("The index access loop does not support two lower bounds (given when accessing " + this.indexUnresolved + ").");
            return false;
        }
        return bl;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        if (this.expr != null) {
            this.expr = this.expr.evaluate();
        }
        if (this.expr2 != null) {
            this.expr2 = this.expr2.evaluate();
        }
        ForIndexAccessOrdering forIndexAccessOrdering = new ForIndexAccessOrdering(this.iterationVariable.checkIR(Variable.class), new IndexAccessOrdering(this.index.checkIR(Index.class), this.ascending, this.comp, this.expr != null ? this.expr.checkIR(Expression.class) : null, this.comp2, this.expr2 != null ? this.expr2.checkIR(Expression.class) : null));
        for (EvalStatementNode evalStatementNode : this.statements.getChildren()) {
            forIndexAccessOrdering.addLoopedStatement(evalStatementNode.checkIR(EvalStatement.class));
        }
        return forIndexAccessOrdering;
    }

    static {
        ForIndexAccessOrderingYieldNode.setName(ForIndexAccessOrderingYieldNode.class, "for index access ordering yield loop");
        indexResolver = new DeclarationResolver<IndexDeclNode>(IndexDeclNode.class);
    }
}

