/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.decl.IndexDeclNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.graph.ForIndexAccessNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.model.Index;
import de.unika.ipd.grgen.ir.pattern.IndexAccessEquality;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.stmt.graph.ForIndexAccessEquality;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ForIndexAccessEqualityYieldNode
extends ForIndexAccessNode {
    private ExprNode expr;
    private static DeclarationResolver<IndexDeclNode> indexResolver;

    public ForIndexAccessEqualityYieldNode(Coords coords, BaseNode baseNode, int n, IdentNode identNode, ExprNode exprNode, PatternGraphLhsNode patternGraphLhsNode, CollectNode<EvalStatementNode> collectNode) {
        super(coords, baseNode, n, identNode, patternGraphLhsNode, collectNode);
        this.expr = exprNode;
        this.becomeParent(this.expr);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.iterationVariableUnresolved, this.iterationVariable));
        vector.add(this.getValidVersion(this.indexUnresolved, this.index));
        vector.add(this.expr);
        vector.add(this.statements);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("iterVar");
        vector.add("index");
        vector.add("expression");
        vector.add("loopedStatements");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = true;
        if (!this.resolveIterationVariable("index access equality")) {
            bl = false;
        }
        this.index = (IndexDeclNode)indexResolver.resolve(this.indexUnresolved, this);
        bl &= this.index != null;
        return bl &= this.expr.resolve();
    }

    @Override
    protected boolean checkLocal() {
        if (!this.checkIterationVariable("index access equality")) {
            return false;
        }
        boolean bl = true;
        TypeNode typeNode = this.index.getExpectedAccessType();
        TypeNode typeNode2 = this.expr.getType();
        if (!typeNode2.isCompatibleTo(typeNode)) {
            this.reportError("Cannot convert type used in accessing index from " + typeNode2.toStringWithDeclarationCoords() + " to the expected " + typeNode.toStringWithDeclarationCoords() + " in index access loop (on " + this.indexUnresolved + ").");
            return false;
        }
        TypeNode typeNode3 = this.iterationVariable.getDeclType();
        InheritanceTypeNode inheritanceTypeNode = this.index.getType();
        if (!inheritanceTypeNode.isCompatibleTo(typeNode3) && !typeNode3.isCompatibleTo(inheritanceTypeNode)) {
            this.reportError("Cannot convert index type from " + inheritanceTypeNode.toStringWithDeclarationCoords() + " to the expected " + typeNode3.toStringWithDeclarationCoords() + " in index access loop (on " + this.indexUnresolved + ").");
            return false;
        }
        return bl;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        this.expr = this.expr.evaluate();
        ForIndexAccessEquality forIndexAccessEquality = new ForIndexAccessEquality(this.iterationVariable.checkIR(Variable.class), new IndexAccessEquality(this.index.checkIR(Index.class), this.expr.checkIR(Expression.class)));
        for (EvalStatementNode evalStatementNode : this.statements.getChildren()) {
            forIndexAccessEquality.addLoopedStatement(evalStatementNode.checkIR(EvalStatement.class));
        }
        return forIndexAccessEquality;
    }

    static {
        ForIndexAccessEqualityYieldNode.setName(ForIndexAccessEqualityYieldNode.class, "for index access equality yield loop");
        indexResolver = new DeclarationResolver<IndexDeclNode>(IndexDeclNode.class);
    }
}

