/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.NestingStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.parser.Coords;

public abstract class ForGraphQueryNode
extends NestingStatementNode {
    BaseNode iterationVariableUnresolved;
    VarDeclNode iterationVariable;

    protected ForGraphQueryNode(Coords coords, BaseNode baseNode, CollectNode<EvalStatementNode> collectNode) {
        super(coords, collectNode);
        this.iterationVariableUnresolved = baseNode;
        this.becomeParent(this.iterationVariableUnresolved);
    }

    protected boolean resolveIterationVariable(String string) {
        boolean bl = true;
        if (this.iterationVariableUnresolved instanceof VarDeclNode) {
            this.iterationVariable = (VarDeclNode)this.iterationVariableUnresolved;
        } else {
            this.reportError("Error in resolving iteration variable of for " + string + " loop.");
            bl = false;
        }
        if (!this.iterationVariable.resolve()) {
            bl = false;
        }
        return bl;
    }

    protected boolean checkIterationVariable(String string) {
        TypeNode typeNode = this.iterationVariable.getDeclType();
        if (!(typeNode instanceof NodeTypeNode) && !(typeNode instanceof EdgeTypeNode)) {
            this.reportError("Iteration variable of for " + string + " loop must be of type Node or Edge (but is of type " + typeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        return true;
    }

    static {
        ForGraphQueryNode.setName(ForGraphQueryNode.class, "ForGraphQuery");
    }
}

