/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.deque;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.QualIdentNode;
import de.unika.ipd.grgen.ast.stmt.deque.DequeProcedureMethodInvocationBaseNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.IntTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.deque.DequeRemoveItem;
import de.unika.ipd.grgen.ir.stmt.deque.DequeVarRemoveItem;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class DequeRemoveItemNode
extends DequeProcedureMethodInvocationBaseNode {
    private ExprNode valueExpr;

    public DequeRemoveItemNode(Coords coords, QualIdentNode qualIdentNode, ExprNode exprNode) {
        super(coords, qualIdentNode);
        if (exprNode != null) {
            this.valueExpr = this.becomeParent(exprNode);
        }
    }

    public DequeRemoveItemNode(Coords coords, VarDeclNode varDeclNode, ExprNode exprNode) {
        super(coords, varDeclNode);
        if (exprNode != null) {
            this.valueExpr = this.becomeParent(exprNode);
        }
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.target != null ? this.target : this.targetVar);
        if (this.valueExpr != null) {
            vector.add(this.valueExpr);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("target");
        if (this.valueExpr != null) {
            vector.add("valueExpr");
        }
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (this.target != null) {
            TypeNode typeNode;
            if (this.valueExpr != null && !(typeNode = this.valueExpr.getType()).isEqual(IntTypeNode.intType)) {
                ExprNode exprNode = this.valueExpr;
                this.valueExpr = this.becomeParent(this.valueExpr.adjustType(IntTypeNode.intType, this.getCoords()));
                if (this.valueExpr == ConstNode.getInvalid()) {
                    exprNode.reportError("The deque rem item procedure expects as argument (index) a value of type int (but is given a value of type " + typeNode.toStringWithDeclarationCoords() + ").");
                    return false;
                }
            }
            return true;
        }
        if (this.valueExpr != null) {
            return this.checkType(this.valueExpr, IntTypeNode.intType, "index value", "deque rem item procedure");
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        if (this.valueExpr != null) {
            this.valueExpr = this.valueExpr.evaluate();
        }
        if (this.target != null) {
            return new DequeRemoveItem(this.target.checkIR(Qualification.class), this.valueExpr != null ? this.valueExpr.checkIR(Expression.class) : null);
        }
        return new DequeVarRemoveItem(this.targetVar.checkIR(Variable.class), this.valueExpr != null ? this.valueExpr.checkIR(Expression.class) : null);
    }

    static {
        DequeRemoveItemNode.setName(DequeRemoveItemNode.class, "deque remove item statement");
    }
}

