/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.array;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.QualIdentNode;
import de.unika.ipd.grgen.ast.stmt.array.ArrayProcedureMethodInvocationBaseNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.IntTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.array.ArrayAddItem;
import de.unika.ipd.grgen.ir.stmt.array.ArrayVarAddItem;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ArrayAddItemNode
extends ArrayProcedureMethodInvocationBaseNode {
    private ExprNode valueExpr;
    private ExprNode indexExpr;

    public ArrayAddItemNode(Coords coords, QualIdentNode qualIdentNode, ExprNode exprNode, ExprNode exprNode2) {
        super(coords, qualIdentNode);
        this.valueExpr = this.becomeParent(exprNode);
        if (exprNode2 != null) {
            this.indexExpr = this.becomeParent(exprNode2);
        }
    }

    public ArrayAddItemNode(Coords coords, VarDeclNode varDeclNode, ExprNode exprNode, ExprNode exprNode2) {
        super(coords, varDeclNode);
        this.valueExpr = this.becomeParent(exprNode);
        if (exprNode2 != null) {
            this.indexExpr = this.becomeParent(exprNode2);
        }
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.target != null ? this.target : this.targetVar);
        vector.add(this.valueExpr);
        if (this.indexExpr != null) {
            vector.add(this.indexExpr);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("target");
        vector.add("valueExpr");
        if (this.indexExpr != null) {
            vector.add("indexExpr");
        }
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        ArrayTypeNode arrayTypeNode = this.getTargetType();
        if (this.target != null) {
            BaseNode baseNode;
            TypeNode typeNode = arrayTypeNode.valueType;
            TypeNode typeNode2 = this.valueExpr.getType();
            if (!typeNode2.isEqual(typeNode)) {
                baseNode = this.valueExpr;
                this.valueExpr = this.becomeParent(this.valueExpr.adjustType(typeNode, this.getCoords()));
                if (this.valueExpr == ConstNode.getInvalid()) {
                    baseNode.reportError("The array add item procedure expects as 1. argument (value) a value of type " + typeNode.toStringWithDeclarationCoords() + " (but is given a value of type " + typeNode2.toStringWithDeclarationCoords() + ").");
                    return false;
                }
            }
            if (this.indexExpr != null && !((TypeNode)(baseNode = this.indexExpr.getType())).isEqual(IntTypeNode.intType)) {
                ExprNode exprNode = this.indexExpr;
                this.indexExpr = this.becomeParent(this.indexExpr.adjustType(IntTypeNode.intType, this.getCoords()));
                if (this.indexExpr == ConstNode.getInvalid()) {
                    exprNode.reportError("The array add item procedure expects as 2. argument (index) a value of type int (but is given a value of type " + baseNode.toStringWithDeclarationCoords() + ").");
                    return false;
                }
            }
            return true;
        }
        boolean bl = true;
        TypeNode typeNode = arrayTypeNode.valueType;
        if (this.indexExpr != null) {
            bl &= this.checkType(this.indexExpr, IntTypeNode.intType, "array add item with index procedure", "index");
        }
        return bl &= this.checkType(this.valueExpr, typeNode, "array add item procedure", "value");
    }

    @Override
    protected IR constructIR() {
        this.valueExpr = this.valueExpr.evaluate();
        if (this.indexExpr != null) {
            this.indexExpr = this.indexExpr.evaluate();
        }
        if (this.target != null) {
            return new ArrayAddItem(this.target.checkIR(Qualification.class), this.valueExpr.checkIR(Expression.class), this.indexExpr != null ? this.indexExpr.checkIR(Expression.class) : null);
        }
        return new ArrayVarAddItem(this.targetVar.checkIR(Variable.class), this.valueExpr.checkIR(Expression.class), this.indexExpr != null ? this.indexExpr.checkIR(Expression.class) : null);
    }

    static {
        ArrayAddItemNode.setName(ArrayAddItemNode.class, "array add item statement");
    }
}

