/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.invocation.ProcedureInvocationDecisionNode;
import de.unika.ipd.grgen.ast.stmt.invocation.ProcedureMethodInvocationDecisionNode;
import de.unika.ipd.grgen.ast.stmt.invocation.ProcedureOrExternalProcedureInvocationNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.stmt.AssignmentBase;
import de.unika.ipd.grgen.ir.stmt.ReturnAssignment;
import de.unika.ipd.grgen.ir.stmt.invocation.ProcedureOrBuiltinProcedureInvocationBase;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ReturnAssignmentNode
extends EvalStatementNode {
    ProcedureOrExternalProcedureInvocationNode procedure;
    ProcedureInvocationDecisionNode builtinProcedure;
    ProcedureMethodInvocationDecisionNode procedureMethod;
    CollectNode<EvalStatementNode> targets;
    int context;

    public ReturnAssignmentNode(Coords coords, ProcedureOrExternalProcedureInvocationNode procedureOrExternalProcedureInvocationNode, CollectNode<EvalStatementNode> collectNode, int n) {
        super(coords);
        this.procedure = procedureOrExternalProcedureInvocationNode;
        this.becomeParent(this.procedure);
        this.targets = collectNode;
        this.becomeParent(this.targets);
        this.context = n;
    }

    public ReturnAssignmentNode(Coords coords, ProcedureInvocationDecisionNode procedureInvocationDecisionNode, CollectNode<EvalStatementNode> collectNode, int n) {
        super(coords);
        this.builtinProcedure = procedureInvocationDecisionNode;
        this.becomeParent(this.builtinProcedure);
        this.targets = collectNode;
        this.becomeParent(this.targets);
        this.context = n;
    }

    public ReturnAssignmentNode(Coords coords, ProcedureMethodInvocationDecisionNode procedureMethodInvocationDecisionNode, CollectNode<EvalStatementNode> collectNode, int n) {
        super(coords);
        this.procedureMethod = procedureMethodInvocationDecisionNode;
        this.becomeParent(this.procedureMethod);
        this.targets = collectNode;
        this.becomeParent(this.targets);
        this.context = n;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.procedure != null ? this.procedure : (this.builtinProcedure != null ? this.builtinProcedure : this.procedureMethod));
        vector.add(this.targets);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("lhs");
        vector.add("rhs");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        if (this.procedure != null) {
            if (this.targets.size() != this.procedure.getNumReturnTypes() && this.targets.size() != 0) {
                this.procedure.reportError("The call of procedure " + this.procedure.getIdentNode() + " expects " + this.procedure.getNumReturnTypes() + " procedure return variables, but given are " + this.targets.size() + " return variables.");
                return false;
            }
        } else if (this.builtinProcedure != null) {
            if (this.targets.size() != this.builtinProcedure.getNumReturnTypes() && this.targets.size() != 0) {
                this.builtinProcedure.reportError("The call of (builtin) procedure " + this.builtinProcedure.getProcedureName() + " expects " + this.builtinProcedure.getNumReturnTypes() + " procedure return variables, but given are " + this.targets.size() + " return variables.");
                return false;
            }
        } else if (this.targets.size() != this.procedureMethod.getNumReturnTypes() && this.targets.size() != 0) {
            this.procedureMethod.reportError("The call of procedure method " + this.procedureMethod.getIdentNode() + " expects " + this.procedureMethod.getNumReturnTypes() + " procedure return variables, but given are " + this.targets.size() + " return variables.");
            return false;
        }
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        ReturnAssignment returnAssignment = this.procedure != null ? new ReturnAssignment(this.procedure.checkIR(ProcedureOrBuiltinProcedureInvocationBase.class)) : (this.builtinProcedure != null ? new ReturnAssignment(this.builtinProcedure.checkIR(ProcedureOrBuiltinProcedureInvocationBase.class)) : new ReturnAssignment(this.procedureMethod.checkIR(ProcedureOrBuiltinProcedureInvocationBase.class)));
        for (EvalStatementNode evalStatementNode : this.targets.getChildren()) {
            returnAssignment.addAssignment(evalStatementNode.checkIR(AssignmentBase.class));
        }
        return returnAssignment;
    }

    static {
        ReturnAssignmentNode.setName(ReturnAssignmentNode.class, "Return Assign");
    }
}

