/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.NestingStatementNode;
import de.unika.ipd.grgen.ast.type.DefinedMatchTypeNode;
import de.unika.ipd.grgen.ast.type.MatchTypeActionNode;
import de.unika.ipd.grgen.ast.type.MatchTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.stmt.MatchesAccumulationYield;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class MatchesAccumulationYieldNode
extends NestingStatementNode {
    VarDeclNode iterationVariableUnresolved;
    IdentNode matchesContainerUnresolved;
    VarDeclNode iterationVariable;
    VarDeclNode matchesContainer;
    private static final DeclarationResolver<VarDeclNode> matchesResolver;

    public MatchesAccumulationYieldNode(Coords coords, VarDeclNode varDeclNode, IdentNode identNode, CollectNode<EvalStatementNode> collectNode) {
        super(coords, collectNode);
        this.iterationVariableUnresolved = varDeclNode;
        this.becomeParent(this.iterationVariableUnresolved);
        this.matchesContainerUnresolved = identNode;
        this.becomeParent(this.matchesContainerUnresolved);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.iterationVariableUnresolved, this.iterationVariable));
        vector.add(this.getValidVersion(this.matchesContainerUnresolved, this.matchesContainer));
        vector.add(this.statements);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("iterationVariable");
        vector.add("matchesContainer");
        vector.add("accumulationStatements");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = true;
        this.matchesContainer = (VarDeclNode)matchesResolver.resolve(this.matchesContainerUnresolved, this);
        if (this.matchesContainer == null) {
            bl = false;
        }
        if (this.iterationVariableUnresolved instanceof VarDeclNode) {
            this.iterationVariable = this.iterationVariableUnresolved;
        } else {
            this.reportError("Error in resolving the iteration variable of the for matches loop.");
            bl = false;
        }
        if (!this.iterationVariable.resolve()) {
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        MatchTypeNode matchTypeNode;
        MatchTypeNode matchTypeNode2;
        TypeNode typeNode = this.matchesContainer.getDeclType();
        if (!(typeNode instanceof ArrayTypeNode)) {
            this.reportError("The for matches loop expects to iterate an array of matches (of type array<match<rule-name>> or array<match<class match-class-name>>), but is given: " + typeNode.toStringWithDeclarationCoords());
            return false;
        }
        TypeNode typeNode2 = ((ArrayTypeNode)typeNode).valueType;
        MatchTypeActionNode matchTypeActionNode = typeNode2 instanceof MatchTypeActionNode ? (MatchTypeActionNode)typeNode2 : null;
        DefinedMatchTypeNode definedMatchTypeNode = typeNode2 instanceof DefinedMatchTypeNode ? (DefinedMatchTypeNode)typeNode2 : null;
        MatchTypeNode matchTypeNode3 = matchTypeNode2 = matchTypeActionNode != null ? matchTypeActionNode : definedMatchTypeNode;
        if (matchTypeActionNode == null && definedMatchTypeNode == null) {
            this.reportError("The for matches loop expects to iterate an array of matches (of type array<match<rule-name>> or array<match<class match-class-name>>), but is given as array element type: " + typeNode2.toStringWithDeclarationCoords());
            return false;
        }
        TypeNode typeNode3 = this.iterationVariable.getDeclType();
        MatchTypeActionNode matchTypeActionNode2 = typeNode3 instanceof MatchTypeActionNode ? (MatchTypeActionNode)typeNode3 : null;
        DefinedMatchTypeNode definedMatchTypeNode2 = typeNode3 instanceof DefinedMatchTypeNode ? (DefinedMatchTypeNode)typeNode3 : null;
        MatchTypeNode matchTypeNode4 = matchTypeNode = matchTypeActionNode2 != null ? matchTypeActionNode2 : definedMatchTypeNode2;
        if (matchTypeActionNode2 == null && definedMatchTypeNode2 == null) {
            this.reportError("The for matches loop expects an iteration variable of match type (match<rule-name> or match<class match-class-name>), but is given: " + typeNode3.toStringWithDeclarationCoords());
            return false;
        }
        if (!matchTypeNode.isEqual(matchTypeNode2)) {
            this.reportError("The iteration variable of the for matches loop is of type " + matchTypeNode.toStringWithDeclarationCoords() + " but the elements in the matches container are of type " + matchTypeNode2.toStringWithDeclarationCoords() + ".");
            return false;
        }
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        MatchesAccumulationYield matchesAccumulationYield = new MatchesAccumulationYield(this.iterationVariable.checkIR(Variable.class), this.matchesContainer.checkIR(Variable.class));
        for (EvalStatementNode evalStatementNode : this.statements.getChildren()) {
            matchesAccumulationYield.addStatement(evalStatementNode.checkIR(EvalStatement.class));
        }
        return matchesAccumulationYield;
    }

    static {
        MatchesAccumulationYieldNode.setName(MatchesAccumulationYieldNode.class, "MatchesAccumulationYield");
        matchesResolver = new DeclarationResolver<VarDeclNode>(VarDeclNode.class);
    }
}

