/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.IteratedDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.NestingStatementNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.stmt.IteratedAccumulationYield;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class IteratedAccumulationYieldNode
extends NestingStatementNode {
    VarDeclNode iterationVariableUnresolved;
    IdentNode iteratedUnresolved;
    VarDeclNode iterationVariable;
    IteratedDeclNode iterated;
    private static final DeclarationResolver<IteratedDeclNode> iteratedResolver;

    public IteratedAccumulationYieldNode(Coords coords, VarDeclNode varDeclNode, IdentNode identNode, CollectNode<EvalStatementNode> collectNode) {
        super(coords, collectNode);
        this.iterationVariableUnresolved = varDeclNode;
        this.becomeParent(this.iterationVariableUnresolved);
        this.iteratedUnresolved = identNode;
        this.becomeParent(this.iteratedUnresolved);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.iterationVariableUnresolved, this.iterationVariable));
        vector.add(this.getValidVersion(this.iteratedUnresolved, this.iterated));
        vector.add(this.statements);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("iterationVariable");
        vector.add("iterated");
        vector.add("accumulationStatements");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = true;
        this.iterated = (IteratedDeclNode)iteratedResolver.resolve(this.iteratedUnresolved, this);
        if (this.iterated == null) {
            bl = false;
        }
        if (this.iterationVariableUnresolved instanceof VarDeclNode) {
            this.iterationVariable = this.iterationVariableUnresolved;
        } else {
            this.reportError("Error in resolving the iteration variable of the for iterated accumulation loop.");
            bl = false;
        }
        if ((this.iterationVariable.context & 1) == 1) {
            this.reportError("A for iterated accumulation loop can only be used within a yield block in the pattern.");
            bl = false;
        }
        boolean bl2 = false;
        for (VarDeclNode declNode : this.iterated.pattern.getDefVariablesToBeYieldedTo().getChildren()) {
            if (!this.iterationVariable.toString().equals(declNode.toString())) continue;
            this.iterationVariable.typeUnresolved = declNode.typeUnresolved;
            bl2 = true;
        }
        for (NodeDeclNode nodeDeclNode : this.iterated.pattern.getNodes()) {
            if (!this.iterationVariable.toString().equals(nodeDeclNode.toString())) continue;
            this.iterationVariable.typeUnresolved = nodeDeclNode.typeUnresolved;
            bl2 = true;
        }
        for (EdgeDeclNode edgeDeclNode : this.iterated.pattern.getEdges()) {
            if (!this.iterationVariable.toString().equals(edgeDeclNode.toString())) continue;
            this.iterationVariable.typeUnresolved = edgeDeclNode.typeUnresolved;
            bl2 = true;
        }
        if (!bl2) {
            this.reportError("Cannot find the iteration variable " + this.iterationVariable + " in the iterated.");
            bl = false;
        }
        if (!this.iterationVariable.resolve()) {
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        IteratedAccumulationYield iteratedAccumulationYield = new IteratedAccumulationYield(this.iterationVariable.checkIR(Variable.class), this.iterated.checkIR(Rule.class));
        for (EvalStatementNode evalStatementNode : this.statements.getChildren()) {
            iteratedAccumulationYield.addStatement(evalStatementNode.checkIR(EvalStatement.class));
        }
        return iteratedAccumulationYield;
    }

    static {
        IteratedAccumulationYieldNode.setName(IteratedAccumulationYieldNode.class, "IteratedAccumulationYield");
        iteratedResolver = new DeclarationResolver<IteratedDeclNode>(IteratedDeclNode.class);
    }
}

