/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.NestingStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.stmt.IntegerRangeIterationYield;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class IntegerRangeIterationYieldNode
extends NestingStatementNode {
    BaseNode iterationVariableUnresolved;
    ExprNode leftExpr;
    ExprNode rightExpr;
    VarDeclNode iterationVariable;

    public IntegerRangeIterationYieldNode(Coords coords, BaseNode baseNode, ExprNode exprNode, ExprNode exprNode2, CollectNode<EvalStatementNode> collectNode) {
        super(coords, collectNode);
        this.iterationVariableUnresolved = baseNode;
        this.becomeParent(this.iterationVariableUnresolved);
        this.leftExpr = exprNode;
        this.becomeParent(this.leftExpr);
        this.rightExpr = exprNode2;
        this.becomeParent(this.rightExpr);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.iterationVariableUnresolved, this.iterationVariable));
        vector.add(this.leftExpr);
        vector.add(this.rightExpr);
        vector.add(this.statements);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("iterationVariable");
        vector.add("left");
        vector.add("right");
        vector.add("accumulationStatements");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = true;
        if (this.iterationVariableUnresolved instanceof VarDeclNode) {
            this.iterationVariable = (VarDeclNode)this.iterationVariableUnresolved;
        } else {
            this.reportError("Error in resolving the iteration variable of the for integer range loop.");
            bl = false;
        }
        if (!this.iterationVariable.resolve()) {
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode = this.iterationVariable.getDeclType();
        if (!typeNode.isEqual(BasicTypeNode.intType)) {
            this.reportError("The for integer range loop expects an iteration variable of type int (but is given " + typeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        TypeNode typeNode2 = this.leftExpr.getType();
        if (!typeNode2.isEqual(BasicTypeNode.intType)) {
            this.reportError("The for integer range loop expects a left bound of type int (but is given " + typeNode2.toStringWithDeclarationCoords() + ").");
            return false;
        }
        TypeNode typeNode3 = this.rightExpr.getType();
        if (!typeNode3.isEqual(BasicTypeNode.intType)) {
            this.reportError("The for integer range loop expects a right bound of type int (but is given " + typeNode3.toStringWithDeclarationCoords() + ").");
            return false;
        }
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        this.leftExpr = this.leftExpr.evaluate();
        this.rightExpr = this.rightExpr.evaluate();
        IntegerRangeIterationYield integerRangeIterationYield = new IntegerRangeIterationYield(this.iterationVariable.checkIR(Variable.class), this.leftExpr.checkIR(Expression.class), this.rightExpr.checkIR(Expression.class));
        for (EvalStatementNode evalStatementNode : this.statements.getChildren()) {
            integerRangeIterationYield.addStatement(evalStatementNode.checkIR(EvalStatement.class));
        }
        return integerRangeIterationYield;
    }

    static {
        IntegerRangeIterationYieldNode.setName(IntegerRangeIterationYieldNode.class, "IntegerRangeIterationYield");
    }
}

