/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ProcedureDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.SubpatternDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.pattern.OrderedReplacementNode;
import de.unika.ipd.grgen.ast.stmt.ConditionStatementNode;
import de.unika.ipd.grgen.ast.stmt.ExecStatementNode;
import de.unika.ipd.grgen.ast.stmt.NestingStatementNode;
import de.unika.ipd.grgen.ast.stmt.ReturnAssignmentNode;
import de.unika.ipd.grgen.ast.stmt.ReturnStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Iterator;

public abstract class EvalStatementNode
extends OrderedReplacementNode {
    public EvalStatementNode(Coords coords) {
        super(coords);
    }

    protected boolean checkType(ExprNode exprNode, TypeNode typeNode, String string, String string2) {
        TypeNode typeNode2;
        TypeNode typeNode3 = exprNode.getType();
        if (!typeNode3.isCompatibleTo(typeNode2 = typeNode)) {
            this.reportError("Cannot convert parameter " + string2 + " of " + string + " from " + typeNode3.toStringWithDeclarationCoords() + " to the expected " + typeNode2.toStringWithDeclarationCoords() + ".");
            return false;
        }
        return true;
    }

    public abstract boolean checkStatementLocal(boolean var1, DeclNode var2, EvalStatementNode var3);

    public static boolean checkStatements(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode, CollectNode<EvalStatementNode> collectNode, boolean bl2) {
        boolean bl3 = true;
        EvalStatementNode evalStatementNode2 = null;
        boolean bl4 = false;
        for (EvalStatementNode evalStatementNode3 : collectNode.getChildren()) {
            EvalStatementNode evalStatementNode4;
            if (bl4) {
                evalStatementNode3.reportError("No statements allowed after a return statement (at the same nesting level; these statements would not be executed).");
                bl3 = false;
            }
            bl3 &= evalStatementNode3.checkStatementLocal(bl, declNode, evalStatementNode);
            evalStatementNode2 = evalStatementNode3;
            if (evalStatementNode3 instanceof ConditionStatementNode) {
                evalStatementNode4 = (ConditionStatementNode)evalStatementNode3;
                bl3 &= EvalStatementNode.checkStatements(bl, declNode, evalStatementNode, evalStatementNode4.statements, false);
                bl3 &= EvalStatementNode.checkStatements(bl, declNode, evalStatementNode, evalStatementNode4.falseCaseStatements, false);
                continue;
            }
            if (evalStatementNode3 instanceof NestingStatementNode) {
                evalStatementNode4 = (NestingStatementNode)evalStatementNode3;
                bl3 &= EvalStatementNode.checkStatements(bl, declNode, evalStatementNode4, evalStatementNode4.statements, false);
                continue;
            }
            if (evalStatementNode3 instanceof ReturnStatementNode) {
                bl4 = true;
                continue;
            }
            if (evalStatementNode3 instanceof ReturnAssignmentNode) {
                if (!(declNode instanceof FunctionDeclNode) && !bl) continue;
                evalStatementNode4 = (ReturnAssignmentNode)evalStatementNode3;
                if (((ReturnAssignmentNode)evalStatementNode4).builtinProcedure != null && ((ReturnAssignmentNode)evalStatementNode4).builtinProcedure.isEmitOrDebugProcedure()) continue;
                if (declNode instanceof FunctionDeclNode) {
                    evalStatementNode3.reportError("A procedure call is not allowed in a function (only emit/emitdebug/assert/assertAlways and the Debug package functions are admissible).");
                } else {
                    evalStatementNode3.reportError("A procedure call is not allowed in a yield block (only emit/emitdebug/assert/assertAlways and the Debug package functions are admissible).");
                }
                bl3 = false;
                continue;
            }
            if (!(evalStatementNode3 instanceof ExecStatementNode) || !(declNode instanceof SubpatternDeclNode)) continue;
            evalStatementNode3.reportError("An exec inside an eval is forbidden in a subpattern -- move it outside of the eval (so it becomes a deferred exec, executed at the end of rewriting, on the by-then current graph and the local entities valid at the end of its local rewriting).");
        }
        if (bl2) {
            if (declNode instanceof FunctionDeclNode && !(evalStatementNode2 instanceof ReturnStatementNode) && ((FunctionDeclNode)declNode).functionAuto == null) {
                if (evalStatementNode2 instanceof ConditionStatementNode) {
                    if (!EvalStatementNode.allCasesEndWithReturn((ConditionStatementNode)evalStatementNode2)) {
                        evalStatementNode2.reportError("All cases of a terminating if in a function must end with a return statement (missing in " + declNode.getKind() + " " + declNode.getIdentNode() + ").");
                        bl3 = false;
                    }
                } else {
                    if (evalStatementNode2 != null && evalStatementNode2.getCoords().hasLocation()) {
                        evalStatementNode2.reportError("A function must end with a return statement (missing in " + declNode.getKind() + " " + declNode.getIdentNode() + ").");
                    } else {
                        declNode.reportError("A function must end with a return statement (missing in " + declNode.getKind() + " " + declNode.getIdentNode() + ").");
                    }
                    bl3 = false;
                }
            }
            if (declNode instanceof ProcedureDeclNode && !(evalStatementNode2 instanceof ReturnStatementNode)) {
                if (evalStatementNode2 instanceof ConditionStatementNode) {
                    if (!EvalStatementNode.allCasesEndWithReturn((ConditionStatementNode)evalStatementNode2)) {
                        evalStatementNode2.reportError("All cases of a terminating if in a procedure must end with a return statement (missing in " + declNode.getKind() + " " + declNode.getIdentNode() + ").");
                        bl3 = false;
                    }
                } else {
                    if (evalStatementNode2 != null && evalStatementNode2.getCoords().hasLocation()) {
                        evalStatementNode2.reportError("A procedure must end with a return statement (missing in " + declNode.getKind() + " " + declNode.getIdentNode() + ").");
                    } else {
                        declNode.reportError("A procedure must end with a return statement (missing in " + declNode.getKind() + " " + declNode.getIdentNode() + ").");
                    }
                    bl3 = false;
                }
            }
        }
        return bl3;
    }

    public static boolean allCasesEndWithReturn(ConditionStatementNode conditionStatementNode) {
        EvalStatementNode evalStatementNode;
        boolean bl = true;
        EvalStatementNode evalStatementNode2 = null;
        Iterator<Object> iterator = conditionStatementNode.statements.getChildren().iterator();
        while (iterator.hasNext()) {
            evalStatementNode2 = evalStatementNode = (EvalStatementNode)iterator.next();
        }
        if (!(evalStatementNode2 instanceof ReturnStatementNode)) {
            if (evalStatementNode2 instanceof ConditionStatementNode) {
                bl &= EvalStatementNode.allCasesEndWithReturn((ConditionStatementNode)evalStatementNode2);
            } else {
                return false;
            }
        }
        evalStatementNode2 = null;
        iterator = conditionStatementNode.falseCaseStatements.getChildren().iterator();
        while (iterator.hasNext()) {
            evalStatementNode2 = evalStatementNode = (EvalStatementNode)iterator.next();
        }
        if (!(evalStatementNode2 instanceof ReturnStatementNode)) {
            if (evalStatementNode2 instanceof ConditionStatementNode) {
                bl &= EvalStatementNode.allCasesEndWithReturn((ConditionStatementNode)evalStatementNode2);
            } else {
                return false;
            }
        }
        return bl;
    }

    public boolean iteratedNotReferenced(String string) {
        boolean bl = true;
        for (BaseNode baseNode : this.getChildren()) {
            if (!(baseNode instanceof ExprNode)) continue;
            bl &= ((ExprNode)baseNode).iteratedNotReferenced(string);
        }
        return bl;
    }

    @Override
    public boolean noExecStatement(boolean bl) {
        boolean bl2 = true;
        for (BaseNode baseNode : this.getChildren()) {
            if (!(baseNode instanceof EvalStatementNode)) continue;
            EvalStatementNode evalStatementNode = (EvalStatementNode)baseNode;
            bl2 &= evalStatementNode.noExecStatement(bl);
        }
        return bl2;
    }
}

