/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.NestingStatementNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.ContainerAccumulationYield;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ContainerAccumulationYieldNode
extends NestingStatementNode {
    VarDeclNode iterationVariableUnresolved;
    VarDeclNode iterationIndexUnresolved;
    IdentNode containerUnresolved;
    VarDeclNode iterationVariable;
    VarDeclNode iterationIndex;
    VarDeclNode container;
    private static final DeclarationResolver<VarDeclNode> containerResolver;

    public ContainerAccumulationYieldNode(Coords coords, VarDeclNode varDeclNode, VarDeclNode varDeclNode2, IdentNode identNode, CollectNode<EvalStatementNode> collectNode) {
        super(coords, collectNode);
        this.iterationVariableUnresolved = varDeclNode;
        this.becomeParent(this.iterationVariableUnresolved);
        this.iterationIndexUnresolved = varDeclNode2;
        if (this.iterationIndexUnresolved != null) {
            this.becomeParent(this.iterationIndexUnresolved);
        }
        this.containerUnresolved = identNode;
        this.becomeParent(this.containerUnresolved);
        this.statements = collectNode;
        this.becomeParent(this.statements);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.iterationVariableUnresolved, this.iterationVariable));
        if (this.iterationIndexUnresolved != null) {
            vector.add(this.getValidVersion(this.iterationIndexUnresolved, this.iterationIndex));
        }
        vector.add(this.getValidVersion(this.containerUnresolved, this.container));
        vector.add(this.statements);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("iterationVariable");
        if (this.iterationIndexUnresolved != null) {
            vector.add("iterationIndex");
        }
        vector.add("container");
        vector.add("accumulationStatements");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = true;
        this.container = (VarDeclNode)containerResolver.resolve(this.containerUnresolved, this);
        if (this.container == null) {
            bl = false;
        }
        if (this.iterationVariableUnresolved instanceof VarDeclNode) {
            this.iterationVariable = this.iterationVariableUnresolved;
        } else {
            this.reportError("Error in resolving the iteration variable of the for loop iterating over a container.");
            bl = false;
        }
        if (this.iterationIndexUnresolved != null) {
            if (this.iterationIndexUnresolved instanceof VarDeclNode) {
                this.iterationIndex = this.iterationIndexUnresolved;
            } else {
                this.reportError("Error in resolving the iteration index variable of the for loop iterating over a container.");
                bl = false;
            }
        }
        if (!this.iterationVariable.resolve()) {
            bl = false;
        }
        if (this.iterationIndex != null && !this.iterationIndex.resolve()) {
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        ContainerAccumulationYield containerAccumulationYield = new ContainerAccumulationYield(this.iterationVariable.checkIR(Variable.class), this.iterationIndex != null ? this.iterationIndex.checkIR(Variable.class) : null, this.container.checkIR(Variable.class));
        for (EvalStatementNode evalStatementNode : this.statements.getChildren()) {
            containerAccumulationYield.addStatement(evalStatementNode.checkIR(EvalStatement.class));
        }
        return containerAccumulationYield;
    }

    static {
        ContainerAccumulationYieldNode.setName(ContainerAccumulationYieldNode.class, "ContainerAccumulationYield");
        containerResolver = new DeclarationResolver<VarDeclNode>(VarDeclNode.class);
    }
}

