/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.NestingStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.ConditionStatement;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ConditionStatementNode
extends NestingStatementNode {
    private ExprNode conditionExpr;
    CollectNode<EvalStatementNode> falseCaseStatements;

    public ConditionStatementNode(Coords coords, ExprNode exprNode, CollectNode<EvalStatementNode> collectNode, CollectNode<EvalStatementNode> collectNode2) {
        super(coords, collectNode);
        this.conditionExpr = exprNode;
        this.becomeParent(exprNode);
        this.falseCaseStatements = collectNode2;
        if (collectNode2 != null) {
            this.becomeParent(this.falseCaseStatements);
        }
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.conditionExpr);
        vector.add(this.statements);
        if (this.falseCaseStatements != null) {
            vector.add(this.falseCaseStatements);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("condition");
        vector.add("trueCaseStatements");
        if (this.falseCaseStatements != null) {
            vector.add("falseCaseStatements");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode = this.conditionExpr.getType();
        if (!typeNode.isEqual(BasicTypeNode.booleanType)) {
            this.conditionExpr.reportError("The condition of the if statement must be of type boolean (but is of type " + typeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        this.conditionExpr = this.conditionExpr.evaluate();
        ConditionStatement conditionStatement = new ConditionStatement(this.conditionExpr.checkIR(Expression.class));
        for (EvalStatementNode evalStatementNode : this.statements.getChildren()) {
            conditionStatement.addStatement(evalStatementNode.checkIR(EvalStatement.class));
        }
        if (this.falseCaseStatements != null) {
            for (EvalStatementNode evalStatementNode : this.falseCaseStatements.getChildren()) {
                conditionStatement.addFalseCaseStatement(evalStatementNode.checkIR(EvalStatement.class));
            }
        }
        return conditionStatement;
    }

    static {
        ConditionStatementNode.setName(ConditionStatementNode.class, "ConditionStatement");
    }
}

