/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.IdentExprNode;
import de.unika.ipd.grgen.ast.expr.QualIdentNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.IntTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.type.container.DequeTypeNode;
import de.unika.ipd.grgen.ast.type.container.MapTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.AssignmentIndexed;
import de.unika.ipd.grgen.ir.stmt.AssignmentVarIndexed;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class AssignIndexedNode
extends EvalStatementNode {
    BaseNode lhsUnresolved;
    ExprNode rhs;
    ExprNode index;
    boolean onLHS;
    QualIdentNode lhsQual;
    VarDeclNode lhsVar;
    int context;

    public AssignIndexedNode(Coords coords, QualIdentNode qualIdentNode, ExprNode exprNode, ExprNode exprNode2, int n) {
        super(coords);
        this.lhsUnresolved = qualIdentNode;
        this.becomeParent(this.lhsUnresolved);
        this.rhs = exprNode;
        this.becomeParent(this.rhs);
        this.index = exprNode2;
        this.becomeParent(this.index);
        this.context = n;
        this.onLHS = false;
    }

    public AssignIndexedNode(Coords coords, IdentExprNode identExprNode, ExprNode exprNode, ExprNode exprNode2, int n, boolean bl) {
        super(coords);
        this.lhsUnresolved = identExprNode;
        this.becomeParent(this.lhsUnresolved);
        this.rhs = exprNode;
        this.becomeParent(this.rhs);
        this.index = exprNode2;
        this.becomeParent(this.index);
        this.context = n;
        this.onLHS = bl;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.lhsUnresolved, this.lhsQual, this.lhsVar));
        vector.add(this.rhs);
        vector.add(this.index);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("lhs");
        vector.add("rhs");
        vector.add("index");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = true;
        if (this.lhsUnresolved instanceof IdentExprNode) {
            IdentExprNode identExprNode = (IdentExprNode)this.lhsUnresolved;
            if (identExprNode.resolve()) {
                if (identExprNode.decl instanceof VarDeclNode) {
                    this.lhsVar = (VarDeclNode)identExprNode.decl;
                } else {
                    this.reportError("Error in resolving the variable on the left hand side of the indexed assignment (given is " + identExprNode.getIdent() + ").");
                    bl = false;
                }
            } else {
                this.reportError("Error in resolving the variable on the left hand side of the indexed assignment (given is " + identExprNode.getIdent() + ").");
                bl = false;
            }
        } else if (this.lhsUnresolved instanceof QualIdentNode) {
            QualIdentNode qualIdentNode = (QualIdentNode)this.lhsUnresolved;
            if (qualIdentNode.resolve()) {
                this.lhsQual = qualIdentNode;
            } else {
                this.reportError("Error in resolving the qualified attribute on the left hand side of the indexed assignment (given is " + qualIdentNode + ").");
                bl = false;
            }
        } else {
            this.reportError("Internal error - invalid left hand side in indexed assignment.");
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        if (this.lhsQual != null) {
            BaseNode baseNode;
            if ((this.context & 0x80) == 0) {
                this.reportError("An indexed assignment to an attribute of a graph element is not allowed in function or pattern part context.");
                return false;
            }
            DeclNode declNode = this.lhsQual.getOwner();
            TypeNode typeNode = declNode.getDeclType();
            if (this.lhsQual.getDecl().isConst()) {
                this.reportError("An indexed assignment to a const member is not allowed (" + this.lhsQual.getDecl().getIdentNode() + this.lhsQual.getDecl().getDeclarationCoords() + " is constant).");
                return false;
            }
            if (typeNode instanceof InheritanceTypeNode && ((InheritanceTypeNode)(baseNode = (InheritanceTypeNode)typeNode)).isConst()) {
                this.reportError("An indexed assignment to a const type object is not allowed (" + baseNode.toStringWithDeclarationCoords() + " is constant).");
                return false;
            }
            if (declNode instanceof ConstraintDeclNode) {
                baseNode = (ConstraintDeclNode)declNode;
                if ((((ConstraintDeclNode)baseNode).context & 0x40) == 64 && this.getCoords().comesBefore(baseNode.getCoords())) {
                    this.reportError("Variables (node,edge,var,ref) of computations must be declared before they can be assigned to (with index) (" + ((DeclNode)baseNode).getIdentNode() + " was not yet declared).");
                    return false;
                }
            }
        } else {
            if ((this.lhsVar.context & 0x40) == 64 && this.getCoords().comesBefore(this.lhsVar.getCoords())) {
                this.reportError("Variables (node,edge,var,ref) of computations must be declared before they can be assigned to (with index) (" + this.lhsVar.getIdentNode() + " was not yet declared).");
                return false;
            }
            if (this.lhsVar.directlyNestingLHSGraph == null && this.onLHS) {
                this.reportError("An indexed assignment to a global variable (" + this.lhsVar.getIdentNode() + ") is not allowed from a yield block.");
                return false;
            }
        }
        return this.typeCheckLocal();
    }

    private boolean typeCheckLocal() {
        TypeNode typeNode = null;
        if (this.lhsQual != null) {
            typeNode = this.lhsQual.getDecl().getDeclType();
        }
        if (this.lhsVar != null) {
            typeNode = this.lhsVar.getDeclType();
        }
        boolean bl = this.checkValueType(typeNode);
        boolean bl2 = this.checkIndexType(typeNode);
        return bl && bl2;
    }

    private boolean checkValueType(TypeNode typeNode) {
        TypeNode typeNode2;
        if (typeNode instanceof ArrayTypeNode) {
            typeNode2 = ((ArrayTypeNode)typeNode).valueType;
        } else if (typeNode instanceof DequeTypeNode) {
            typeNode2 = ((DequeTypeNode)typeNode).valueType;
        } else if (typeNode instanceof MapTypeNode) {
            typeNode2 = ((MapTypeNode)typeNode).valueType;
        } else {
            typeNode.reportError("Can only carry out an indexed assignment on an attribute/variable of array/deque/map type (given is type " + typeNode.getTypeName() + ").");
            return false;
        }
        TypeNode typeNode3 = this.rhs.getType();
        if (typeNode3.isEqual(typeNode2)) {
            return true;
        }
        this.rhs = this.becomeParent(this.rhs.adjustType(typeNode2, this.getCoords()));
        return this.rhs != ConstNode.getInvalid();
    }

    private boolean checkIndexType(TypeNode typeNode) {
        TypeNode typeNode2 = typeNode instanceof MapTypeNode ? ((MapTypeNode)typeNode).keyType : IntTypeNode.intType;
        TypeNode typeNode3 = this.index.getType();
        if (typeNode3 instanceof InheritanceTypeNode) {
            if (typeNode3.isCompatibleTo(typeNode2)) {
                return true;
            }
            this.reportError("Cannot convert index in assignment from " + typeNode3.toStringWithDeclarationCoords() + " to the expected " + typeNode2.toStringWithDeclarationCoords() + ".");
            return false;
        }
        if (typeNode3.isEqual(typeNode2)) {
            return true;
        }
        this.index = this.becomeParent(this.index.adjustType(typeNode2, this.getCoords()));
        return this.index != ConstNode.getInvalid();
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        if (this.lhsQual != null) {
            Qualification qualification = this.lhsQual.checkIR(Qualification.class);
            if (qualification.getOwner() instanceof Node && ((Node)qualification.getOwner()).changesType(null)) {
                this.reportError("An assignment to a node whose type will be changed is not allowed.");
            }
            if (qualification.getOwner() instanceof Edge && ((Edge)qualification.getOwner()).changesType(null)) {
                this.reportError("An assignment to an edge whose type will be changed is not allowed.");
            }
            ExprNode exprNode = this.rhs.evaluate();
            ExprNode exprNode2 = this.index.evaluate();
            return new AssignmentIndexed(qualification, exprNode.checkIR(Expression.class), exprNode2.checkIR(Expression.class));
        }
        Variable variable = this.lhsVar.checkIR(Variable.class);
        ExprNode exprNode = this.rhs.evaluate();
        ExprNode exprNode3 = this.index.evaluate();
        return new AssignmentVarIndexed(variable, exprNode.checkIR(Expression.class), exprNode3.checkIR(Expression.class));
    }

    static {
        AssignIndexedNode.setName(AssignIndexedNode.class, "Assign indexed");
    }
}

