/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.RhsDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.SubpatternUsageDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.IdentExprNode;
import de.unika.ipd.grgen.ast.pattern.OrderedReplacementNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.pattern.SubpatternDependentReplacement;
import de.unika.ipd.grgen.ir.pattern.SubpatternUsage;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Vector;

public class SubpatternReplNode
extends OrderedReplacementNode {
    private IdentNode subpatternUnresolved;
    private SubpatternUsageDeclNode subpattern;
    private CollectNode<ExprNode> replConnections;
    private static final DeclarationResolver<SubpatternUsageDeclNode> subpatternResolver;

    public SubpatternReplNode(IdentNode identNode, CollectNode<ExprNode> collectNode) {
        this.subpatternUnresolved = identNode;
        this.becomeParent(this.subpatternUnresolved);
        this.replConnections = collectNode;
        this.becomeParent(this.replConnections);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.subpatternUnresolved, this.subpattern));
        vector.add(this.replConnections);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("subpattern");
        vector.add("replConnections");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.subpattern = (SubpatternUsageDeclNode)subpatternResolver.resolve(this.subpatternUnresolved, this);
        return this.subpattern != null;
    }

    @Override
    protected boolean checkLocal() {
        RhsDeclNode rhsDeclNode = this.subpattern.type.right;
        String string = this.subpattern.type.pattern.nameOfGraph;
        if ((this.subpattern.context & 1) != 0) {
            this.subpatternUnresolved.reportError("A subpattern rewrite application can only be given for a subpattern entity declaration from the pattern part, but is given for a subpattern entity declaration from the rewrite part (this occurs for " + this.subpatternUnresolved + "()) (only a subpattern entity matched can be rewritten, not one just created).");
            return false;
        }
        if (rhsDeclNode == null) {
            this.subpattern.type.pattern.reportError("No rewrite part specified in subpattern " + string + " (which is referenced by the subpattern rewrite application " + this.subpatternUnresolved + ").");
            return false;
        }
        return this.checkSubpatternSignatureAdhered();
    }

    private boolean checkSubpatternSignatureAdhered() {
        int n;
        PatternGraphLhsNode patternGraphLhsNode = this.subpattern.type.pattern;
        RhsDeclNode rhsDeclNode = this.subpattern.type.right;
        Vector<DeclNode> vector = rhsDeclNode.patternGraph.getParamDecls();
        int n2 = vector.size();
        if (n2 != (n = this.replConnections.size())) {
            this.subpattern.ident.reportError("The rewrite part specified in " + patternGraphLhsNode.toStringWithDeclarationCoords() + " expects " + n2 + " parameters, but given by the subpattern rewrite application " + this.subpatternUnresolved + " are " + n + " arguments.");
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < vector.size(); ++i) {
            ExprNode exprNode = this.replConnections.get(i);
            DeclNode declNode = vector.get(i);
            if (exprNode instanceof IdentExprNode && ((IdentExprNode)exprNode).yieldedTo) {
                bl &= this.checkYieldedToParameter(i, exprNode, declNode);
                continue;
            }
            bl &= this.checkParameter(i, exprNode, declNode);
        }
        return bl;
    }

    private boolean checkYieldedToParameter(int n, ExprNode exprNode, DeclNode declNode) {
        BaseNode baseNode;
        boolean bl = true;
        PatternGraphLhsNode patternGraphLhsNode = this.subpattern.type.pattern;
        TypeNode typeNode = exprNode.getType();
        TypeNode typeNode2 = declNode.getDeclType();
        if (declNode instanceof ConstraintDeclNode) {
            baseNode = (ConstraintDeclNode)declNode;
            if (!((ConstraintDeclNode)baseNode).defEntityToBeYieldedTo) {
                bl = false;
                this.subpatternUnresolved.reportError("The " + (n + 1) + ". argument to the subpattern rewrite application " + this.subpatternUnresolved + " is yielded to, but the rewrite parameter at this position is not declared as def (" + ((DeclNode)baseNode).getIdentNode() + " in " + patternGraphLhsNode.toStringWithDeclarationCoords() + ").");
            }
        } else {
            baseNode = (VarDeclNode)declNode;
            if (!((VarDeclNode)baseNode).defEntityToBeYieldedTo) {
                bl = false;
                this.subpatternUnresolved.reportError("The " + (n + 1) + ". argument to the subpattern rewrite application " + this.subpatternUnresolved + " is yielded to, but the rewrite parameter at this position is not declared as def (" + ((DeclNode)baseNode).getIdentNode() + " in " + patternGraphLhsNode.toStringWithDeclarationCoords() + ").");
            }
        }
        baseNode = ((IdentExprNode)exprNode).getResolvedNode();
        if (baseNode instanceof VarDeclNode) {
            VarDeclNode varDeclNode = (VarDeclNode)baseNode;
            if ((varDeclNode.context & 1) == 0) {
                bl = false;
                this.subpatternUnresolved.reportError("Cannot yield from a subpattern rewrite application (" + (n + 1) + " argument of " + this.subpatternUnresolved + ") in the rewrite part to a def variable in the pattern part (" + varDeclNode.getIdentNode() + " was declared in the pattern part).");
            }
        } else {
            BaseNode baseNode2 = baseNode;
            if ((((ConstraintDeclNode)baseNode2).context & 1) == 0) {
                bl = false;
                this.subpatternUnresolved.reportError("Cannot yield from a subpattern rewrite application (" + (n + 1) + " argument of " + this.subpatternUnresolved + ") in the rewrite part to a def graph element in the pattern part (" + ((DeclNode)baseNode2).getIdentNode() + " was declared in the pattern part).");
            }
        }
        if (!typeNode2.isCompatibleTo(typeNode)) {
            bl = false;
            this.subpatternUnresolved.reportError("The " + (n + 1) + ". argument of type " + typeNode.getTypeName() + " of the subpattern rewrite application " + this.subpatternUnresolved + " cannot be yielded to from the rewrite def parameter of incompatible type " + typeNode2.getTypeName() + " (" + declNode.getIdentNode() + " of subpattern " + patternGraphLhsNode.toStringWithDeclarationCoords() + ")" + typeNode.toStringWithDeclarationCoordsIfCoordsAreOfInterest() + typeNode2.toStringWithDeclarationCoordsIfCoordsAreOfInterest() + ".");
        }
        return bl;
    }

    private boolean checkParameter(int n, ExprNode exprNode, DeclNode declNode) {
        boolean bl = true;
        PatternGraphLhsNode patternGraphLhsNode = this.subpattern.type.pattern;
        TypeNode typeNode = exprNode.getType();
        TypeNode typeNode2 = declNode.getDeclType();
        if (declNode instanceof ConstraintDeclNode) {
            ConstraintDeclNode constraintDeclNode = (ConstraintDeclNode)declNode;
            if (constraintDeclNode.defEntityToBeYieldedTo) {
                bl = false;
                this.subpatternUnresolved.reportError("The " + (n + 1) + ". argument of the subpattern rewrite application " + this.subpatternUnresolved + " is not yielded to, but the rewrite parameter at this position is declared as def (" + constraintDeclNode.getIdentNode() + " in " + patternGraphLhsNode.toStringWithDeclarationCoords() + ").");
            }
        } else {
            VarDeclNode varDeclNode = (VarDeclNode)declNode;
            if (varDeclNode.defEntityToBeYieldedTo) {
                bl = false;
                this.subpatternUnresolved.reportError("The " + (n + 1) + ". argument of the subpattern rewrite application " + this.subpatternUnresolved + " is not yielded to, but the rewrite parameter at this position is declared as def (" + varDeclNode.getIdentNode() + " in " + patternGraphLhsNode.toStringWithDeclarationCoords() + ").");
            }
        }
        if (!typeNode.isCompatibleTo(typeNode2)) {
            bl = false;
            this.subpatternUnresolved.reportError("Cannot convert " + (n + 1) + ". argument of the subpattern rewrite application " + this.subpatternUnresolved + " from " + typeNode.getTypeName() + " to " + typeNode2.getTypeName() + " (expected by the rewrite parameter " + declNode.getIdentNode() + " of subpattern " + patternGraphLhsNode.toStringWithDeclarationCoords() + ")" + typeNode.toStringWithDeclarationCoordsIfCoordsAreOfInterest() + typeNode2.toStringWithDeclarationCoordsIfCoordsAreOfInterest() + ".");
        }
        return bl;
    }

    public IdentNode getSubpatternIdent() {
        return this.subpatternUnresolved;
    }

    @Override
    protected IR constructIR() {
        LinkedList<Expression> linkedList = new LinkedList<Expression>();
        for (ExprNode exprNode : this.replConnections.getChildren()) {
            exprNode = exprNode.evaluate();
            linkedList.add(exprNode.checkIR(Expression.class));
        }
        return new SubpatternDependentReplacement("dependent replacement", this.subpatternUnresolved.getIdent(), this.subpattern.checkIR(SubpatternUsage.class), linkedList);
    }

    static {
        SubpatternReplNode.setName(SubpatternReplNode.class, "subpattern repl node");
        subpatternResolver = new DeclarationResolver<SubpatternUsageDeclNode>(SubpatternUsageDeclNode.class);
    }
}

