/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.RuleDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.AlternativeCaseDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.AlternativeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.IteratedDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.SubpatternUsageDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.BoolConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.pattern.ConnectionCharacter;
import de.unika.ipd.grgen.ast.pattern.ConnectionNode;
import de.unika.ipd.grgen.ast.pattern.ExactNode;
import de.unika.ipd.grgen.ast.pattern.HomNode;
import de.unika.ipd.grgen.ast.pattern.HomStorage;
import de.unika.ipd.grgen.ast.pattern.InducedNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphBaseNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphBuilder;
import de.unika.ipd.grgen.ast.pattern.SingleNodeConnNode;
import de.unika.ipd.grgen.ast.pattern.SubpatternReplNode;
import de.unika.ipd.grgen.ast.pattern.TotallyHomNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementsNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.pattern.Alternative;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.pattern.SubpatternUsage;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.EvalStatements;
import de.unika.ipd.grgen.parser.Coords;
import de.unika.ipd.grgen.parser.SymbolTable;
import de.unika.ipd.grgen.util.Base;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;

public class PatternGraphLhsNode
extends PatternGraphBaseNode {
    public static final int MOD_DANGLING = 1;
    public static final int MOD_IDENTIFICATION = 2;
    public static final int MOD_EXACT = 4;
    public static final int MOD_INDUCED = 8;
    public static final int MOD_PATTERN_LOCKED = 16;
    public static final int MOD_PATTERNPATH_LOCKED = 32;
    private int modifiers = 0;
    private CollectNode<ExprNode> conditions;
    public CollectNode<EvalStatementsNode> yields;
    public CollectNode<AlternativeDeclNode> alts;
    public CollectNode<IteratedDeclNode> iters;
    public CollectNode<PatternGraphLhsNode> negs;
    public CollectNode<PatternGraphLhsNode> idpts;
    public CollectNode<HomNode> homs;
    private CollectNode<TotallyHomNode> totallyHoms;
    public CollectNode<ExactNode> exacts;
    public CollectNode<InducedNode> induceds;
    private HomStorage homStorage;
    protected boolean hasAbstractElements;
    public boolean iterationBreaking = false;
    private static PatternGraphLhsNode invalid;

    public static PatternGraphLhsNode getInvalid() {
        if (invalid == null) {
            invalid = new PatternGraphLhsNode("invalid", Coords.getInvalid(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0, 64);
        }
        return invalid;
    }

    public PatternGraphLhsNode(String string, Coords coords, CollectNode<BaseNode> collectNode, CollectNode<BaseNode> collectNode2, CollectNode<SubpatternUsageDeclNode> collectNode3, CollectNode<SubpatternReplNode> collectNode4, CollectNode<AlternativeDeclNode> collectNode5, CollectNode<IteratedDeclNode> collectNode6, CollectNode<PatternGraphLhsNode> collectNode7, CollectNode<PatternGraphLhsNode> collectNode8, CollectNode<ExprNode> collectNode9, CollectNode<ExprNode> collectNode10, CollectNode<HomNode> collectNode11, CollectNode<TotallyHomNode> collectNode12, CollectNode<ExactNode> collectNode13, CollectNode<InducedNode> collectNode14, int n, int n2) {
        super(string, coords, collectNode, collectNode2, collectNode3, collectNode10, n2);
        this.alts = collectNode5;
        this.becomeParent(this.alts);
        this.iters = collectNode6;
        this.becomeParent(this.iters);
        this.negs = collectNode7;
        this.becomeParent(this.negs);
        this.idpts = collectNode8;
        this.becomeParent(this.idpts);
        this.conditions = collectNode9;
        this.becomeParent(this.conditions);
        this.homs = collectNode11;
        this.becomeParent(this.homs);
        this.totallyHoms = collectNode12;
        this.becomeParent(this.totallyHoms);
        this.exacts = collectNode13;
        this.becomeParent(this.exacts);
        this.induceds = collectNode14;
        this.becomeParent(this.induceds);
        this.modifiers = n;
        this.directlyNestingLHSGraph = this;
        if (collectNode2 != null) {
            this.addParamsToConnections(collectNode2);
        }
    }

    public void addYieldings(CollectNode<EvalStatementsNode> collectNode) {
        this.yields = collectNode;
        this.becomeParent(this.yields);
    }

    @Override
    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.connectionsUnresolved, this.connections));
        vector.add(this.params);
        vector.add(this.defVariablesToBeYieldedTo);
        vector.add(this.subpatterns);
        vector.add(this.alts);
        vector.add(this.iters);
        vector.add(this.negs);
        vector.add(this.idpts);
        vector.add(this.returns);
        vector.add(this.yields);
        vector.add(this.conditions);
        vector.add(this.homs);
        vector.add(this.totallyHoms);
        vector.add(this.exacts);
        vector.add(this.induceds);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("connections");
        vector.add("params");
        vector.add("defVariablesToBeYieldedTo");
        vector.add("subpatterns");
        vector.add("alternatives");
        vector.add("iters");
        vector.add("negatives");
        vector.add("independents");
        vector.add("return");
        vector.add("yields");
        vector.add("conditions");
        vector.add("homs");
        vector.add("totallyHoms");
        vector.add("exacts");
        vector.add("induceds");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = super.resolveLocal();
        this.determineExistenceOfAbstractElements();
        return bl;
    }

    void determineExistenceOfAbstractElements() {
        for (ConnectionCharacter connectionCharacter : this.connections.getChildren()) {
            ConnectionCharacter connectionCharacter2;
            if (connectionCharacter instanceof ConnectionNode) {
                connectionCharacter2 = (ConnectionNode)connectionCharacter;
                if (!((ConnectionNode)connectionCharacter2).getEdge().getDeclType().isAbstract() && !((ConnectionNode)connectionCharacter2).getSrc().getDeclType().isAbstract() && !((ConnectionNode)connectionCharacter2).getTgt().getDeclType().isAbstract()) continue;
                this.hasAbstractElements = true;
                continue;
            }
            if (!(connectionCharacter instanceof SingleNodeConnNode) || !((SingleNodeConnNode)(connectionCharacter2 = (SingleNodeConnNode)connectionCharacter)).getNode().getDeclType().isAbstract()) continue;
            this.hasAbstractElements = true;
        }
    }

    @Override
    protected Set<NodeDeclNode> getNodesImpl() {
        assert (this.isResolved());
        LinkedHashSet<NodeDeclNode> linkedHashSet = new LinkedHashSet<NodeDeclNode>();
        for (ConnectionCharacter baseNode : this.connections.getChildren()) {
            baseNode.addNodes(linkedHashSet);
        }
        for (HomNode homNode : this.homs.getChildren()) {
            for (NodeDeclNode nodeDeclNode : homNode.getHomNodes()) {
                linkedHashSet.add(nodeDeclNode);
            }
        }
        return linkedHashSet;
    }

    @Override
    protected Set<EdgeDeclNode> getEdgesImpl() {
        assert (this.isResolved());
        LinkedHashSet<EdgeDeclNode> linkedHashSet = new LinkedHashSet<EdgeDeclNode>();
        for (ConnectionCharacter baseNode : this.connections.getChildren()) {
            baseNode.addEdge(linkedHashSet);
        }
        for (HomNode homNode : this.homs.getChildren()) {
            for (EdgeDeclNode edgeDeclNode : homNode.getHomEdges()) {
                linkedHashSet.add(edgeDeclNode);
            }
        }
        return linkedHashSet;
    }

    public NodeDeclNode tryGetNode(String string) {
        for (NodeDeclNode nodeDeclNode : this.getNodes()) {
            if (!nodeDeclNode.ident.toString().equals(string)) continue;
            return nodeDeclNode;
        }
        return null;
    }

    public EdgeDeclNode tryGetEdge(String string) {
        for (EdgeDeclNode edgeDeclNode : this.getEdges()) {
            if (!edgeDeclNode.ident.toString().equals(string)) continue;
            return edgeDeclNode;
        }
        return null;
    }

    public VarDeclNode tryGetVar(String string) {
        for (VarDeclNode declNode : this.defVariablesToBeYieldedTo.getChildren()) {
            if (!declNode.ident.toString().equals(string)) continue;
            return declNode;
        }
        for (DeclNode declNode : this.getParamDecls()) {
            if (!(declNode instanceof VarDeclNode)) continue;
            VarDeclNode varDeclNode = (VarDeclNode)declNode;
            if (!varDeclNode.ident.toString().equals(string)) continue;
            return varDeclNode;
        }
        return null;
    }

    public DeclNode tryGetMember(String string) {
        NodeDeclNode nodeDeclNode = this.tryGetNode(string);
        if (nodeDeclNode != null) {
            return nodeDeclNode;
        }
        EdgeDeclNode edgeDeclNode = this.tryGetEdge(string);
        if (edgeDeclNode != null) {
            return edgeDeclNode;
        }
        return this.tryGetVar(string);
    }

    public PatternGraphLhsNode getParentPatternGraph() {
        for (BaseNode baseNode : this.getParents()) {
            if (!(baseNode instanceof CollectNode)) continue;
            for (BaseNode baseNode2 : baseNode.getParents()) {
                if (!(baseNode2 instanceof PatternGraphLhsNode)) continue;
                return (PatternGraphLhsNode)baseNode2;
            }
        }
        return null;
    }

    public boolean isInduced() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isDangling() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isIdentification() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isExact() {
        return (this.modifiers & 4) != 0;
    }

    public NodeDeclNode getAnonymousDummyNode(TypeDeclNode typeDeclNode, int n) {
        IdentNode identNode = new IdentNode(this.getScope().defineAnonymous("dummy_node", SymbolTable.getInvalid(), Coords.getBuiltin()));
        NodeDeclNode nodeDeclNode = NodeDeclNode.getDummy(identNode, typeDeclNode, n, this);
        return nodeDeclNode;
    }

    public EdgeDeclNode getAnonymousEdgeDecl(TypeDeclNode typeDeclNode, int n) {
        IdentNode identNode = new IdentNode(this.getScope().defineAnonymous("edge", SymbolTable.getInvalid(), Coords.getBuiltin()));
        EdgeDeclNode edgeDeclNode = new EdgeDeclNode(identNode, typeDeclNode, n, this, this);
        return edgeDeclNode;
    }

    public Collection<Set<ConstraintDeclNode>> getHoms() {
        if (this.homStorage == null) {
            this.homStorage = new HomStorage(this);
        }
        return this.homStorage.getHoms();
    }

    public Set<NodeDeclNode> getHomomorphic(NodeDeclNode nodeDeclNode) {
        if (this.homStorage == null) {
            this.homStorage = new HomStorage(this);
        }
        return this.homStorage.getHomomorphic(nodeDeclNode);
    }

    public Set<EdgeDeclNode> getHomomorphic(EdgeDeclNode edgeDeclNode) {
        if (this.homStorage == null) {
            this.homStorage = new HomStorage(this);
        }
        return this.homStorage.getHomomorphic(edgeDeclNode);
    }

    private void warnOnSuperfluousHoms() {
        Collection<Set<ConstraintDeclNode>> collection = this.getHoms();
        for (Set<ConstraintDeclNode> set : collection) {
            this.warnOnSuperfluousHoms(set);
        }
    }

    private void warnOnSuperfluousHoms(Set<ConstraintDeclNode> set) {
        LinkedHashSet<ConstraintDeclNode> linkedHashSet = new LinkedHashSet<ConstraintDeclNode>();
        for (ConstraintDeclNode constraintDeclNode : set) {
            InheritanceTypeNode inheritanceTypeNode = constraintDeclNode.getDeclType();
            for (ConstraintDeclNode constraintDeclNode2 : set) {
                InheritanceTypeNode inheritanceTypeNode2;
                if (constraintDeclNode == constraintDeclNode2 || linkedHashSet.contains(constraintDeclNode2) || InheritanceTypeNode.hasCommonSubtype(inheritanceTypeNode, inheritanceTypeNode2 = constraintDeclNode2.getDeclType())) continue;
                HomNode homNode = null;
                for (HomNode homNode2 : this.homs.getChildren()) {
                    Collection<BaseNode> collection = homNode2.getChildren();
                    if (!collection.contains(constraintDeclNode) || !collection.contains(constraintDeclNode2)) continue;
                    homNode = homNode2;
                    break;
                }
                if (homNode == null) continue;
                homNode.reportWarning("The " + constraintDeclNode.getKind() + " " + constraintDeclNode.ident + " and the " + constraintDeclNode2.getKind() + " " + constraintDeclNode2.ident + " have no common subtype and thus can never match the same element.");
            }
            linkedHashSet.add(constraintDeclNode);
        }
    }

    boolean noRewriteInIteratedOrAlternativeNestedInNegativeOrIndependent() {
        boolean bl = true;
        for (PatternGraphLhsNode patternGraphLhsNode : this.negs.getChildren()) {
            for (IteratedDeclNode iteratedDeclNode : patternGraphLhsNode.iters.getChildren()) {
                if (iteratedDeclNode.right == null) continue;
                iteratedDeclNode.right.reportError("An iterated contained within a negative cannot possess a rewrite part (the negative is a pure (negative) application condition).");
                bl = false;
            }
            for (AlternativeDeclNode alternativeDeclNode : patternGraphLhsNode.alts.getChildren()) {
                for (AlternativeCaseDeclNode alternativeCaseDeclNode : alternativeDeclNode.getChildren()) {
                    if (alternativeCaseDeclNode.right == null) continue;
                    alternativeCaseDeclNode.right.reportError("An alternative case contained within a negative cannot possess a rewrite part (the negative is a pure (negative) application condition).");
                    bl = false;
                }
            }
        }
        for (PatternGraphLhsNode patternGraphLhsNode : this.idpts.getChildren()) {
            for (IteratedDeclNode iteratedDeclNode : patternGraphLhsNode.iters.getChildren()) {
                if (iteratedDeclNode.right == null) continue;
                iteratedDeclNode.right.reportError("An iterated contained within an independent cannot possess a rewrite part (the independent is a pure (positive) application condition).");
                bl = false;
            }
            for (AlternativeDeclNode alternativeDeclNode : patternGraphLhsNode.alts.getChildren()) {
                for (AlternativeCaseDeclNode alternativeCaseDeclNode : alternativeDeclNode.getChildren()) {
                    if (alternativeCaseDeclNode.right == null) continue;
                    alternativeCaseDeclNode.right.reportError("An alternative case contained within an independent cannot possess a rewrite part (the independent is a pure (positive) application condition).");
                    bl = false;
                }
            }
        }
        return bl;
    }

    boolean noExecStatementInEvalsOfIteratedOrAlternative() {
        boolean bl = true;
        for (IteratedDeclNode declNode : this.iters.getChildren()) {
            if (declNode.right == null) continue;
            for (EvalStatementsNode evalStatementsNode : declNode.right.getRhsGraph().evals.getChildren()) {
                evalStatementsNode.noExecStatement();
            }
        }
        for (AlternativeDeclNode alternativeDeclNode : this.alts.getChildren()) {
            for (AlternativeCaseDeclNode alternativeCaseDeclNode : alternativeDeclNode.getChildren()) {
                if (alternativeCaseDeclNode.right == null) continue;
                for (EvalStatementsNode evalStatementsNode : alternativeCaseDeclNode.right.getRhsGraph().evals.getChildren()) {
                    evalStatementsNode.noExecStatement();
                }
            }
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = true;
        for (ExprNode exprNode : this.conditions.getChildren()) {
            if (exprNode.getType().isEqual(BasicTypeNode.booleanType)) continue;
            exprNode.reportError("An expression in an if condition must be of type boolean (but is of type " + exprNode.getType().getTypeName() + ").");
            bl = false;
        }
        boolean bl2 = true;
        if ((this.context & 8) == 8 && this.returns.size() != 0) {
            this.reportError("A return is not allowed in a negative block.");
            bl2 = false;
        }
        if ((this.context & 0x10) == 16 && this.returns.size() != 0) {
            this.reportError("A return is not allowed in an independent block.");
            bl2 = false;
        }
        this.warnOnSuperfluousHoms();
        return this.isEdgeReuseOk() & bl & bl2 & this.noRewriteInIteratedOrAlternativeNestedInNegativeOrIndependent() & this.noDefElementOrIteratedReferenceInCondition() & this.noIteratedReferenceInDefElementInitialization() & this.iteratedNameIsNotAccessedInNestedPattern() & this.noExecStatementInEvalsOfIteratedOrAlternative();
    }

    private boolean noDefElementOrIteratedReferenceInCondition() {
        boolean bl = true;
        for (ExprNode exprNode : this.conditions.getChildren()) {
            bl &= exprNode.noDefElement("if condition");
            bl &= exprNode.noIteratedReference("if condition");
        }
        return bl;
    }

    private boolean noIteratedReferenceInDefElementInitialization() {
        boolean bl = true;
        for (VarDeclNode varDeclNode : this.defVariablesToBeYieldedTo.getChildren()) {
            if (varDeclNode.initialization == null) continue;
            bl &= varDeclNode.initialization.noIteratedReference("def variable initialization");
        }
        return bl;
    }

    private boolean iteratedNameIsNotAccessedInNestedPattern() {
        boolean bl = true;
        for (IteratedDeclNode iteratedDeclNode : this.iters.getChildren()) {
            String string = iteratedDeclNode.getIdentNode().toString();
            for (IteratedDeclNode iteratedDeclNode2 : this.iters.getChildren()) {
                bl &= iteratedDeclNode2.pattern.iteratedNotReferenced(string);
                if (iteratedDeclNode2.right == null) continue;
                bl &= iteratedDeclNode2.right.patternGraph.iteratedNotReferenced(string);
                bl &= iteratedDeclNode2.right.patternGraph.iteratedNotReferencedInDefElementInitialization(string);
            }
            for (AlternativeDeclNode alternativeDeclNode : this.alts.getChildren()) {
                for (AlternativeCaseDeclNode alternativeCaseDeclNode : alternativeDeclNode.getChildren()) {
                    bl &= alternativeCaseDeclNode.pattern.iteratedNotReferenced(string);
                    if (alternativeCaseDeclNode.right == null) continue;
                    bl &= alternativeCaseDeclNode.right.patternGraph.iteratedNotReferenced(string);
                    bl &= alternativeCaseDeclNode.right.patternGraph.iteratedNotReferencedInDefElementInitialization(string);
                }
            }
            for (PatternGraphLhsNode patternGraphLhsNode : this.idpts.getChildren()) {
                bl &= patternGraphLhsNode.iteratedNotReferenced(string);
            }
        }
        return bl;
    }

    protected boolean iteratedNotReferenced(String string) {
        boolean bl = true;
        for (EvalStatementsNode evalStatementsNode : this.yields.getChildren()) {
            for (EvalStatementNode evalStatementNode : evalStatementsNode.getChildren()) {
                bl &= evalStatementNode.iteratedNotReferenced(string);
            }
        }
        return bl;
    }

    public boolean checkFilterVariable(IdentNode identNode, String string, String string2) {
        VarDeclNode varDeclNode = this.tryGetVar(string2);
        if (varDeclNode == null) {
            identNode.reportError("The variable " + string2 + " is not known" + this.filterSpecification(string) + ".");
            return false;
        }
        TypeNode typeNode = varDeclNode.getDeclType();
        if (!typeNode.isOrderableType()) {
            identNode.reportError("The variable " + string2 + " must be of one of the following types: " + TypeNode.getOrderableTypesAsString() + " (but is of type " + typeNode.getTypeName() + ")" + this.filterSpecification(string) + ".");
            return false;
        }
        return true;
    }

    public boolean checkFilterEntity(IdentNode identNode, String string, String string2) {
        DeclNode declNode = this.tryGetNode(string2);
        if (declNode == null) {
            declNode = this.tryGetEdge(string2);
        }
        if (declNode == null) {
            declNode = this.tryGetVar(string2);
        }
        if (declNode == null) {
            identNode.reportError("The entity " + string2 + " is not known" + this.filterSpecification(string) + ".");
            return false;
        }
        TypeNode typeNode = ((DeclNode)declNode).getDeclType();
        if (!typeNode.isFilterableType()) {
            identNode.reportError("The entity " + string2 + " must be of one of the following types: " + TypeNode.getFilterableTypesAsString() + " (but is of type " + typeNode.getTypeName() + ")" + this.filterSpecification(string) + ".");
            return false;
        }
        return true;
    }

    private String filterSpecification(String string) {
        return " (in filter " + string + " for " + this.nameOfGraph + ")";
    }

    public PatternGraphLhs getPatternGraph() {
        return this.checkIR(PatternGraphLhs.class);
    }

    public RuleDeclNode getRule() {
        for (BaseNode baseNode : this.getParents()) {
            if (!(baseNode instanceof RuleDeclNode)) continue;
            return (RuleDeclNode)baseNode;
        }
        assert (false);
        return null;
    }

    @Override
    protected IR constructIR() {
        Base base;
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        PatternGraphLhs patternGraphLhs = new PatternGraphLhs(this.nameOfGraph, this.modifiers);
        patternGraphLhs.setDirectlyNestingLHSGraph(patternGraphLhs);
        this.setIR(patternGraphLhs);
        if (this == PatternGraphLhsNode.getInvalid()) {
            return patternGraphLhs;
        }
        patternGraphLhs.setIterationBreaking(this.iterationBreaking);
        for (ConnectionCharacter object : this.connections.getChildren()) {
            object.addToGraph(patternGraphLhs);
        }
        for (VarDeclNode varDeclNode : this.defVariablesToBeYieldedTo.getChildren()) {
            patternGraphLhs.addVariable(varDeclNode.checkIR(Variable.class));
        }
        for (BaseNode baseNode : this.subpatterns.getChildren()) {
            patternGraphLhs.addSubpatternUsage(baseNode.checkIR(SubpatternUsage.class));
        }
        for (AlternativeDeclNode alternativeDeclNode : this.alts.getChildren()) {
            patternGraphLhs.addAlternative(alternativeDeclNode.checkIR(Alternative.class));
        }
        for (IteratedDeclNode iteratedDeclNode : this.iters.getChildren()) {
            patternGraphLhs.addIterated(iteratedDeclNode.checkIR(Rule.class));
        }
        for (PatternGraphLhsNode patternGraphLhsNode : this.negs.getChildren()) {
            base = patternGraphLhsNode.getPatternGraph();
            patternGraphLhs.addNegGraph((PatternGraphLhs)base);
            if (!((PatternGraphLhs)base).isIterationBreaking()) continue;
            patternGraphLhs.setIterationBreaking(true);
        }
        for (PatternGraphLhsNode patternGraphLhsNode : this.idpts.getChildren()) {
            base = patternGraphLhsNode.getPatternGraph();
            patternGraphLhs.addIdptGraph((PatternGraphLhs)base);
            if (!((PatternGraphLhs)base).isIterationBreaking()) continue;
            patternGraphLhs.setIterationBreaking(true);
        }
        for (ExprNode exprNode : this.conditions.getChildren()) {
            base = exprNode.evaluate();
            PatternGraphLhsNode.warnIfConditionIsConstant((ExprNode)base);
            patternGraphLhs.addCondition(((BaseNode)base).checkIR(Expression.class));
        }
        for (EvalStatements evalStatements : this.getYieldStatements()) {
            patternGraphLhs.addYield(evalStatements);
        }
        for (Node node : patternGraphLhs.getNodes()) {
            PatternGraphBuilder.genTypeConditionsFromTypeof(patternGraphLhs, node);
        }
        for (Edge edge : patternGraphLhs.getEdges()) {
            PatternGraphBuilder.genTypeConditionsFromTypeof(patternGraphLhs, edge);
        }
        for (Set set : this.getHoms()) {
            PatternGraphBuilder.addHoms(patternGraphLhs, set);
        }
        for (TotallyHomNode totallyHomNode : this.totallyHoms.getChildren()) {
            PatternGraphBuilder.addTotallyHom(patternGraphLhs, totallyHomNode);
        }
        for (Node node : patternGraphLhs.getNodes()) {
            PatternGraphBuilder.ensureDefNodesAreHomToAllOthers(patternGraphLhs, node);
        }
        for (Edge edge : patternGraphLhs.getEdges()) {
            PatternGraphBuilder.ensureDefEdgesAreHomToAllOthers(patternGraphLhs, edge);
        }
        for (Node node : patternGraphLhs.getNodes()) {
            PatternGraphBuilder.ensureRetypedNodeHomToOldNode(patternGraphLhs, node);
        }
        for (Edge edge : patternGraphLhs.getEdges()) {
            PatternGraphBuilder.ensureRetypedEdgeHomToOldEdge(patternGraphLhs, edge);
        }
        PatternGraphBuilder.addElementsHiddenInUsedConstructs(this, patternGraphLhs);
        return patternGraphLhs;
    }

    private static void warnIfConditionIsConstant(ExprNode exprNode) {
        if (exprNode instanceof BoolConstNode) {
            if (((Boolean)((BoolConstNode)exprNode).getValue()).booleanValue()) {
                exprNode.reportWarning("The if condition is always true.");
            } else {
                exprNode.reportWarning("The if condition is always false, thus the pattern will never match.");
            }
        }
    }

    public Collection<EvalStatements> getYieldStatements() {
        LinkedList<EvalStatements> linkedList = new LinkedList<EvalStatements>();
        for (EvalStatementsNode evalStatementsNode : this.yields.getChildren()) {
            linkedList.add(evalStatementsNode.checkIR(EvalStatements.class));
        }
        return linkedList;
    }

    static {
        PatternGraphLhsNode.setName(PatternGraphLhsNode.class, "pattern graph lhs");
    }
}

