/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.DummyNodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.SubpatternUsageDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EnumTypeNode;
import de.unika.ipd.grgen.ast.model.type.ExternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalTransientObjectTypeNode;
import de.unika.ipd.grgen.ast.pattern.ConnectionCharacter;
import de.unika.ipd.grgen.ast.pattern.ConnectionNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.pattern.SingleGraphEntityNode;
import de.unika.ipd.grgen.ast.pattern.SingleNodeConnNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.container.ContainerTypeNode;
import de.unika.ipd.grgen.ast.util.CollectTripleResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTripleResolver;
import de.unika.ipd.grgen.ast.util.Triple;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;

public abstract class PatternGraphBaseNode
extends BaseNode {
    protected CollectNode<BaseNode> connectionsUnresolved;
    protected CollectNode<ConnectionCharacter> connections = new CollectNode();
    protected CollectNode<SubpatternUsageDeclNode> subpatterns;
    public CollectNode<ExprNode> returns;
    public CollectNode<BaseNode> params;
    public CollectNode<VarDeclNode> defVariablesToBeYieldedTo;
    protected Set<NodeDeclNode> nodes;
    protected Set<EdgeDeclNode> edges;
    protected Set<VarDeclNode> variables;
    protected Set<DeclNode> entities;
    protected int context = 0;
    PatternGraphLhsNode directlyNestingLHSGraph;
    public String nameOfGraph;
    private static final CollectTripleResolver<ConnectionNode, SingleNodeConnNode, SingleGraphEntityNode> connectionsResolver;

    public PatternGraphBaseNode(String string, Coords coords, CollectNode<BaseNode> collectNode, CollectNode<BaseNode> collectNode2, CollectNode<SubpatternUsageDeclNode> collectNode3, CollectNode<ExprNode> collectNode4, int n) {
        super(coords);
        this.nameOfGraph = string;
        this.connectionsUnresolved = collectNode;
        this.becomeParent(this.connectionsUnresolved);
        this.subpatterns = collectNode3;
        this.becomeParent(this.subpatterns);
        this.returns = collectNode4;
        this.becomeParent(this.returns);
        this.params = collectNode2;
        this.becomeParent(this.params);
        this.context = n;
    }

    public void addDefVariablesToBeYieldedTo(CollectNode<VarDeclNode> collectNode) {
        this.defVariablesToBeYieldedTo = collectNode;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.connectionsUnresolved, this.connections));
        vector.add(this.params);
        vector.add(this.defVariablesToBeYieldedTo);
        vector.add(this.subpatterns);
        vector.add(this.returns);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("connections");
        vector.add("params");
        vector.add("defVariablesToBeYieldedTo");
        vector.add("subpatterns");
        vector.add("orderedReplacements");
        vector.add("returns");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        Triple<CollectNode<ConnectionNode>, CollectNode<SingleNodeConnNode>, CollectNode<SingleGraphEntityNode>> triple = connectionsResolver.resolve(this.connectionsUnresolved);
        if (triple != null) {
            if (triple.first != null) {
                for (BaseNode baseNode : ((CollectNode)triple.first).getChildren()) {
                    if (!baseNode.resolve()) {
                        return false;
                    }
                    this.connections.addChild((ConnectionCharacter)baseNode);
                }
            }
            if (triple.second != null) {
                for (BaseNode baseNode : ((CollectNode)triple.second).getChildren()) {
                    if (!baseNode.resolve()) {
                        return false;
                    }
                    this.connections.addChild((ConnectionCharacter)baseNode);
                }
            }
            if (triple.third != null) {
                for (BaseNode baseNode : ((CollectNode)triple.third).getChildren()) {
                    if (!baseNode.resolve()) {
                        return false;
                    }
                    if (((SingleGraphEntityNode)baseNode).getEntityNode() != null) {
                        SingleNodeConnNode singleNodeConnNode = new SingleNodeConnNode(((SingleGraphEntityNode)baseNode).getEntityNode());
                        if (!singleNodeConnNode.resolve()) {
                            return false;
                        }
                        this.connections.addChild(singleNodeConnNode);
                    }
                    if (((SingleGraphEntityNode)baseNode).getEntitySubpattern() == null) continue;
                    this.subpatterns.addChild(((SingleGraphEntityNode)baseNode).getEntitySubpattern());
                }
            }
            this.becomeParent(this.connections);
            this.becomeParent(this.subpatterns);
        }
        boolean bl = this.resolveParamVars();
        boolean bl2 = this.resolveSubpatternUsages();
        return triple != null && bl && bl2;
    }

    private boolean resolveParamVars() {
        boolean bl = true;
        for (BaseNode baseNode : this.params.getChildren()) {
            if (!(baseNode instanceof VarDeclNode)) continue;
            VarDeclNode varDeclNode = (VarDeclNode)baseNode;
            if (varDeclNode.resolve()) {
                if (varDeclNode.getDeclType() instanceof BasicTypeNode || varDeclNode.getDeclType() instanceof EnumTypeNode || varDeclNode.getDeclType() instanceof ContainerTypeNode || varDeclNode.getDeclType() instanceof InternalObjectTypeNode || varDeclNode.getDeclType() instanceof InternalTransientObjectTypeNode || varDeclNode.getDeclType() instanceof ExternalObjectTypeNode) continue;
                varDeclNode.typeUnresolved.reportError("The type of variable " + varDeclNode.getIdentNode() + " must be a basic type (like int or string), or an enum, or a container type (set|map|array|deque), or an object type (class) " + "(but it is " + varDeclNode.getDeclType().toStringWithDeclarationCoords() + ").");
                bl = false;
                continue;
            }
            bl = false;
        }
        return bl;
    }

    private boolean resolveSubpatternUsages() {
        boolean bl = true;
        if ((this.context & 1) == 1) {
            for (SubpatternUsageDeclNode subpatternUsageDeclNode : this.subpatterns.getChildren()) {
                if (subpatternUsageDeclNode.resolve()) {
                    PatternGraphLhsNode patternGraphLhsNode = subpatternUsageDeclNode.getSubpatternDeclNode().getPattern();
                    if (!patternGraphLhsNode.hasAbstractElements) continue;
                    subpatternUsageDeclNode.reportError("Cannot instantiate a pattern with abstract elements (attempted with " + subpatternUsageDeclNode.emptyWhenAnonymous(subpatternUsageDeclNode.getIdentNode() + " of (sub)pattern type ") + patternGraphLhsNode.toStringWithDeclarationCoords() + ").");
                    bl = false;
                    continue;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected boolean isEdgeReuseOk() {
        boolean bl = true;
        HashSet<EdgeDeclNode> hashSet = new HashSet<EdgeDeclNode>();
        for (ConnectionCharacter connectionCharacter : this.connections.getChildren()) {
            EdgeDeclNode edgeDeclNode = connectionCharacter.getEdge();
            if (edgeDeclNode == null || connectionCharacter instanceof ConnectionNode && connectionCharacter.getSrc() instanceof DummyNodeDeclNode && connectionCharacter.getTgt() instanceof DummyNodeDeclNode || hashSet.add(edgeDeclNode)) continue;
            EdgeDeclNode edgeDeclNode2 = edgeDeclNode;
            edgeDeclNode2.reportError("The edge " + edgeDeclNode2.getIdentNode() + " is used more than once in a pattern graph of this action (" + this.nameOfGraph + ").");
            bl = false;
        }
        return bl;
    }

    public Collection<ConnectionCharacter> getConnections() {
        assert (this.isResolved());
        return this.connections.getChildren();
    }

    public Set<NodeDeclNode> getNodes() {
        if (this.nodes == null) {
            this.nodes = Collections.unmodifiableSet(this.getNodesImpl());
        }
        return this.nodes;
    }

    protected Set<NodeDeclNode> getNodesImpl() {
        assert (this.isResolved());
        LinkedHashSet<NodeDeclNode> linkedHashSet = new LinkedHashSet<NodeDeclNode>();
        for (ConnectionCharacter connectionCharacter : this.connections.getChildren()) {
            connectionCharacter.addNodes(linkedHashSet);
        }
        return linkedHashSet;
    }

    public Set<EdgeDeclNode> getEdges() {
        if (this.edges == null) {
            this.edges = Collections.unmodifiableSet(this.getEdgesImpl());
        }
        return this.edges;
    }

    protected Set<EdgeDeclNode> getEdgesImpl() {
        assert (this.isResolved());
        LinkedHashSet<EdgeDeclNode> linkedHashSet = new LinkedHashSet<EdgeDeclNode>();
        for (ConnectionCharacter connectionCharacter : this.connections.getChildren()) {
            connectionCharacter.addEdge(linkedHashSet);
        }
        return linkedHashSet;
    }

    public CollectNode<VarDeclNode> getDefVariablesToBeYieldedTo() {
        return this.defVariablesToBeYieldedTo;
    }

    public Set<VarDeclNode> getVariables() {
        if (this.variables == null) {
            this.variables = Collections.unmodifiableSet(this.getVariablesImpl());
        }
        return this.variables;
    }

    protected Set<VarDeclNode> getVariablesImpl() {
        assert (this.isResolved());
        LinkedHashSet<VarDeclNode> linkedHashSet = new LinkedHashSet<VarDeclNode>();
        for (BaseNode baseNode : this.params.getChildren()) {
            if (!(baseNode instanceof VarDeclNode)) continue;
            linkedHashSet.add((VarDeclNode)baseNode);
        }
        for (VarDeclNode varDeclNode : this.defVariablesToBeYieldedTo.getChildren()) {
            linkedHashSet.add(varDeclNode);
        }
        return linkedHashSet;
    }

    public Set<DeclNode> getEntities() {
        if (this.entities == null) {
            LinkedHashSet<DeclNode> linkedHashSet = new LinkedHashSet<DeclNode>();
            linkedHashSet.addAll(this.getNodes());
            linkedHashSet.addAll(this.getEdges());
            linkedHashSet.addAll(this.getVariables());
            this.entities = Collections.unmodifiableSet(linkedHashSet);
        }
        return this.entities;
    }

    protected void addParamsToConnections(CollectNode<BaseNode> collectNode) {
        for (BaseNode baseNode : collectNode.getChildren()) {
            ConnectionCharacter connectionCharacter;
            if (baseNode instanceof VarDeclNode) {
                ((VarDeclNode)baseNode).directlyNestingLHSGraph = this.directlyNestingLHSGraph;
                continue;
            }
            if (baseNode instanceof SingleNodeConnNode) {
                connectionCharacter = (SingleNodeConnNode)baseNode;
                ((NodeDeclNode)connectionCharacter.nodeUnresolved).directlyNestingLHSGraph = this.directlyNestingLHSGraph;
            } else if (baseNode instanceof ConstraintDeclNode) {
                ((ConstraintDeclNode)baseNode).directlyNestingLHSGraph = this.directlyNestingLHSGraph;
            } else {
                connectionCharacter = (ConnectionNode)baseNode;
                ((EdgeDeclNode)((ConnectionNode)connectionCharacter).edgeUnresolved).directlyNestingLHSGraph = this.directlyNestingLHSGraph;
            }
            this.connectionsUnresolved.addChild(baseNode);
        }
    }

    public Vector<DeclNode> getParamDecls() {
        Vector<DeclNode> vector = new Vector<DeclNode>();
        for (BaseNode baseNode : this.params.getChildren()) {
            BaseNode baseNode2;
            if (baseNode instanceof ConnectionNode) {
                baseNode2 = (ConnectionNode)baseNode;
                vector.add(baseNode2.getEdge().getDecl());
                continue;
            }
            if (baseNode instanceof SingleNodeConnNode) {
                baseNode2 = ((SingleNodeConnNode)baseNode).getNode();
                vector.add((DeclNode)baseNode2);
                continue;
            }
            if (baseNode instanceof VarDeclNode) {
                vector.add((VarDeclNode)baseNode);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported parameter (" + baseNode + ").");
        }
        return vector;
    }

    public Set<String> getNamesOfEntities() {
        return this.getEntities().stream().map(declNode -> declNode.ident.toString()).filter(string -> !string.startsWith("$")).collect(Collectors.toSet());
    }

    static {
        PatternGraphBaseNode.setName(PatternGraphBaseNode.class, "pattern graph base");
        connectionsResolver = new CollectTripleResolver(new DeclarationTripleResolver<ConnectionNode, SingleNodeConnNode, SingleGraphEntityNode>(ConnectionNode.class, SingleNodeConnNode.class, SingleGraphEntityNode.class));
    }
}

