/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.parser.Coords;
import java.awt.Color;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;

public class InducedNode
extends BaseNode {
    private Vector<NodeDeclNode> children = new Vector();
    private Vector<BaseNode> childrenUnresolved = new Vector();
    private static final DeclarationResolver<NodeDeclNode> childrenResolver;

    public InducedNode(Coords coords) {
        super(coords);
    }

    public void addChild(BaseNode baseNode) {
        assert (!this.isResolved());
        this.becomeParent(baseNode);
        this.childrenUnresolved.add(baseNode);
    }

    public Collection<BaseNode> getChildren() {
        return this.getValidVersionVector(this.childrenUnresolved, this.children);
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = true;
        for (int i = 0; i < this.childrenUnresolved.size(); ++i) {
            this.children.add((NodeDeclNode)childrenResolver.resolve(this.childrenUnresolved.get(i), this));
            bl = this.children.get(i) != null && bl;
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        if (this.children.isEmpty()) {
            this.reportError("Induced statement is empty.");
            return false;
        }
        LinkedHashSet<NodeDeclNode> linkedHashSet = new LinkedHashSet<NodeDeclNode>();
        for (NodeDeclNode nodeDeclNode : this.children) {
            if (linkedHashSet.contains(nodeDeclNode)) {
                this.reportWarning("Multiple occurrence of " + nodeDeclNode.getKind() + " " + nodeDeclNode.getIdentNode().getSymbol().getText() + " in a single induced statement.");
            }
            linkedHashSet.add(nodeDeclNode);
        }
        return true;
    }

    public Set<NodeDeclNode> getInducedNodesSet() {
        LinkedHashSet<NodeDeclNode> linkedHashSet = new LinkedHashSet<NodeDeclNode>();
        for (NodeDeclNode nodeDeclNode : this.children) {
            linkedHashSet.add(nodeDeclNode);
        }
        return linkedHashSet;
    }

    @Override
    public Color getNodeColor() {
        return Color.PINK;
    }

    static {
        InducedNode.setName(InducedNode.class, "induced");
        childrenResolver = new DeclarationResolver<NodeDeclNode>(NodeDeclNode.class);
    }
}

