/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.pattern;

import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.pattern.ConnectionCharacter;
import de.unika.ipd.grgen.ast.pattern.ConnectionNode;
import de.unika.ipd.grgen.ast.pattern.InducedNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.util.Base;
import de.unika.ipd.grgen.util.Pair;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImplicitNegComputerInduced {
    PatternGraphLhsNode patternGraph;
    private Set<Pair<NodeDeclNode, NodeDeclNode>> nodePairsRequiringNeg = new LinkedHashSet<Pair<NodeDeclNode, NodeDeclNode>>();
    private Map<Pair<Set<NodeDeclNode>, Set<NodeDeclNode>>, Set<ConnectionNode>> homNodePairsToEdges = new LinkedHashMap<Pair<Set<NodeDeclNode>, Set<NodeDeclNode>>, Set<ConnectionNode>>();
    int implicitNegCounter = 0;

    public ImplicitNegComputerInduced(PatternGraphLhsNode patternGraphLhsNode) {
        this.patternGraph = patternGraphLhsNode;
        if (patternGraphLhsNode.isInduced()) {
            this.nodesRequiringPairNeg(patternGraphLhsNode.getNodes());
            for (InducedNode inducedNode : patternGraphLhsNode.induceds.getChildren()) {
                inducedNode.reportWarning("Induced statement occurs in induced pattern");
            }
            return;
        }
        LinkedHashMap<Set<NodeDeclNode>, Integer> linkedHashMap = new LinkedHashMap<Set<NodeDeclNode>, Integer>();
        for (int i = 0; i < patternGraphLhsNode.induceds.getChildren().size(); ++i) {
            InducedNode inducedNode = patternGraphLhsNode.induceds.get(i);
            Set<NodeDeclNode> set = inducedNode.getInducedNodesSet();
            if (linkedHashMap.containsKey(set)) {
                InducedNode inducedNode2 = patternGraphLhsNode.induceds.get((Integer)linkedHashMap.get(set));
                inducedNode.reportWarning("Same induced statement also occurs at " + inducedNode2.getCoords());
                continue;
            }
            this.nodesRequiringPairNeg(set);
            linkedHashMap.put(set, i);
        }
        ImplicitNegComputerInduced.warnRedundantInducedStatement(patternGraphLhsNode.induceds, linkedHashMap);
    }

    private void nodesRequiringPairNeg(Set<NodeDeclNode> set) {
        for (NodeDeclNode nodeDeclNode : set) {
            if (nodeDeclNode.isDummy()) continue;
            for (NodeDeclNode nodeDeclNode2 : set) {
                if (nodeDeclNode2.isDummy()) continue;
                Pair<NodeDeclNode, NodeDeclNode> pair = new Pair<NodeDeclNode, NodeDeclNode>(nodeDeclNode, nodeDeclNode2);
                this.nodePairsRequiringNeg.add(pair);
                Pair<Set<NodeDeclNode>, Set<NodeDeclNode>> pair2 = new Pair<Set<NodeDeclNode>, Set<NodeDeclNode>>(this.patternGraph.getHomomorphic(nodeDeclNode), this.patternGraph.getHomomorphic(nodeDeclNode2));
                if (this.homNodePairsToEdges.containsKey(pair2)) continue;
                this.homNodePairsToEdges.put(pair2, new LinkedHashSet());
            }
        }
    }

    public LinkedList<PatternGraphLhs> getImplicitNegGraphs() {
        Object object;
        Object object2;
        assert (this.patternGraph.isResolved());
        LinkedList<PatternGraphLhs> linkedList = new LinkedList<PatternGraphLhs>();
        for (Object object3 : this.patternGraph.connections.getChildren()) {
            ConnectionNode object4;
            if (!(object3 instanceof ConnectionNode) || (object2 = this.homNodePairsToEdges.get(object = new Pair<Set<NodeDeclNode>, Set<NodeDeclNode>>(this.patternGraph.getHomomorphic((object4 = (ConnectionNode)object3).getSrc()), this.patternGraph.getHomomorphic(object4.getTgt())))) == null) continue;
            object2.add(object4);
            this.homNodePairsToEdges.put((Pair<Set<NodeDeclNode>, Set<NodeDeclNode>>)object, (Set<ConnectionNode>)object2);
        }
        TypeDeclNode typeDeclNode = this.patternGraph.getArbitraryEdgeRootTypeDecl();
        for (Pair pair : this.nodePairsRequiringNeg) {
            ConnectionNode connectionNode2;
            object = (NodeDeclNode)pair.first;
            object2 = (NodeDeclNode)pair.second;
            if (((Base)object).getId().compareTo(((Base)object2).getId()) > 0) continue;
            Pair<Set<NodeDeclNode>, Set<NodeDeclNode>> pair2 = new Pair<Set<NodeDeclNode>, Set<NodeDeclNode>>(this.patternGraph.getHomomorphic((NodeDeclNode)object), this.patternGraph.getHomomorphic((NodeDeclNode)object2));
            Pair<Set<NodeDeclNode>, Set<NodeDeclNode>> pair3 = new Pair<Set<NodeDeclNode>, Set<NodeDeclNode>>(this.patternGraph.getHomomorphic((NodeDeclNode)object2), this.patternGraph.getHomomorphic((NodeDeclNode)object));
            Set<ConnectionNode> set = this.homNodePairsToEdges.get(pair2);
            set.addAll((Collection<ConnectionNode>)this.homNodePairsToEdges.get(pair3));
            PatternGraphLhs patternGraphLhs = new PatternGraphLhs("implnegind_" + this.implicitNegCounter, 0);
            ++this.implicitNegCounter;
            patternGraphLhs.setDirectlyNestingLHSGraph(patternGraphLhs);
            LinkedHashSet<EdgeDeclNode> linkedHashSet = new LinkedHashSet<EdgeDeclNode>();
            LinkedHashSet<NodeDeclNode> linkedHashSet2 = new LinkedHashSet<NodeDeclNode>();
            for (ConnectionNode connectionNode2 : set) {
                connectionNode2.addToGraph(patternGraphLhs);
                linkedHashSet.add(connectionNode2.getEdge());
                linkedHashSet2.add(connectionNode2.getSrc());
                linkedHashSet2.add(connectionNode2.getTgt());
            }
            this.addInheritedHomSet(patternGraphLhs, linkedHashSet, linkedHashSet2);
            EdgeDeclNode edgeDeclNode = this.patternGraph.getAnonymousEdgeDecl(typeDeclNode, this.patternGraph.context);
            connectionNode2 = new ConnectionNode((NodeDeclNode)object, edgeDeclNode, (NodeDeclNode)object2, ConnectionNode.ConnectionKind.ARBITRARY, this.patternGraph);
            ((ConnectionCharacter)connectionNode2).addToGraph(patternGraphLhs);
            linkedList.add(patternGraphLhs);
        }
        return linkedList;
    }

    private void addInheritedHomSet(PatternGraphLhs patternGraphLhs, Set<EdgeDeclNode> set, Set<NodeDeclNode> set2) {
        Set<ConstraintDeclNode> set3;
        LinkedHashSet<Node> linkedHashSet;
        for (NodeDeclNode constraintDeclNode : set2) {
            linkedHashSet = new LinkedHashSet<Node>();
            set3 = this.patternGraph.getHomomorphic(constraintDeclNode);
            for (ConstraintDeclNode constraintDeclNode2 : set3) {
                if (!set2.contains(constraintDeclNode2)) continue;
                linkedHashSet.add(constraintDeclNode2.checkIR(Node.class));
            }
            if (linkedHashSet.size() <= 1) continue;
            patternGraphLhs.addHomomorphicNodes(linkedHashSet);
        }
        for (EdgeDeclNode edgeDeclNode : set) {
            linkedHashSet = new LinkedHashSet();
            set3 = this.patternGraph.getHomomorphic(edgeDeclNode);
            for (ConstraintDeclNode constraintDeclNode2 : set3) {
                if (!set.contains(constraintDeclNode2)) continue;
                linkedHashSet.add((Node)((Object)constraintDeclNode2.checkIR(Edge.class)));
            }
            if (linkedHashSet.size() <= 1) continue;
            patternGraphLhs.addHomomorphicEdges(linkedHashSet);
        }
    }

    private static void warnRedundantInducedStatement(CollectNode<InducedNode> collectNode, Map<Set<NodeDeclNode>, Integer> map) {
        LinkedHashMap<Map<List<NodeDeclNode>, Boolean>, Integer> linkedHashMap = new LinkedHashMap<Map<List<NodeDeclNode>, Boolean>, Integer>();
        for (Map.Entry<Set<NodeDeclNode>, Integer> entry : map.entrySet()) {
            ImplicitNegComputerInduced.fillInducedEdgeMap(linkedHashMap, entry);
        }
        for (Map.Entry<Set<NodeDeclNode>, Integer> entry : linkedHashMap.entrySet()) {
            Set<Integer> set = ImplicitNegComputerInduced.getWitnessesAndMarkEdge(linkedHashMap, entry);
            if (!ImplicitNegComputerInduced.allMarked(entry)) continue;
            String string = "";
            for (Integer n : set) {
                string = string + collectNode.get(n).getCoords() + " ";
            }
            string = string.trim();
            collectNode.get(entry.getValue()).reportWarning("Induced statement is redundant, since covered by statement(s) at " + string);
        }
    }

    private static void fillInducedEdgeMap(Map<Map<List<NodeDeclNode>, Boolean>, Integer> map, Map.Entry<Set<NodeDeclNode>, Integer> entry) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (NodeDeclNode nodeDeclNode : entry.getKey()) {
            for (NodeDeclNode nodeDeclNode2 : entry.getKey()) {
                LinkedList<NodeDeclNode> linkedList = new LinkedList<NodeDeclNode>();
                linkedList.add(nodeDeclNode);
                linkedList.add(nodeDeclNode2);
                linkedHashMap.put(linkedList, false);
            }
        }
        map.put(linkedHashMap, entry.getValue());
    }

    private static Set<Integer> getWitnessesAndMarkEdge(Map<Map<List<NodeDeclNode>, Boolean>, Integer> map, Map.Entry<Map<List<NodeDeclNode>, Boolean>, Integer> entry) {
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        for (Map.Entry<List<NodeDeclNode>, Boolean> entry2 : entry.getKey().entrySet()) {
            if (entry2.getValue().booleanValue()) continue;
            for (Map.Entry<Map<List<NodeDeclNode>, Boolean>, Integer> entry3 : map.entrySet()) {
                if (entry == entry3 || !entry3.getKey().containsKey(entry2.getKey())) continue;
                entry2.setValue(true);
                linkedHashSet.add(entry3.getValue());
            }
        }
        return linkedHashSet;
    }

    private static boolean allMarked(Map.Entry<Map<List<NodeDeclNode>, Boolean>, Integer> entry) {
        boolean bl = true;
        for (boolean bl2 : entry.getKey().values()) {
            bl &= bl2;
        }
        return bl;
    }
}

