/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.pattern.HomNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class HomStorage {
    private Collection<Set<ConstraintDeclNode>> homSets = new LinkedHashSet<Set<ConstraintDeclNode>>();
    private Map<EdgeDeclNode, Set<EdgeDeclNode>> edgeToHomEdges = new LinkedHashMap<EdgeDeclNode, Set<EdgeDeclNode>>();
    private Map<NodeDeclNode, Set<NodeDeclNode>> nodeToHomNodes = new LinkedHashMap<NodeDeclNode, Set<NodeDeclNode>>();
    private Set<NodeDeclNode> emptyHomNodeSet = new LinkedHashSet<NodeDeclNode>();
    private Set<EdgeDeclNode> emptyHomEdgeSet = new LinkedHashSet<EdgeDeclNode>();

    public HomStorage(PatternGraphLhsNode patternGraphLhsNode) {
        Set<ConstraintDeclNode> set;
        Object object;
        if (patternGraphLhsNode.isIdentification()) {
            object = patternGraphLhsNode.getRule().getDeletedElements();
            for (HomNode set2 : patternGraphLhsNode.homs.getChildren()) {
                set = HomStorage.getDeleteHomSet(set2.getChildren(), (Set<ConstraintDeclNode>)object);
                HomStorage.addIfNonTrivialHomSet(this.homSets, set);
                Set<ConstraintDeclNode> set3 = HomStorage.getReuseHomSet(set2.getChildren(), (Set<ConstraintDeclNode>)object);
                HomStorage.addIfNonTrivialHomSet(this.homSets, set3);
            }
        } else {
            object = patternGraphLhsNode.homs.getChildren().iterator();
            while (object.hasNext()) {
                Iterator<Set<ConstraintDeclNode>> iterator = (HomNode)object.next();
                Set<ConstraintDeclNode> set4 = HomStorage.getHomSet(((HomNode)((Object)iterator)).getChildren());
                HomStorage.addIfNonTrivialHomSet(this.homSets, set4);
            }
        }
        for (object = patternGraphLhsNode.getParentPatternGraph(); object != null; object = ((PatternGraphLhsNode)object).getParentPatternGraph()) {
            for (Set<ConstraintDeclNode> set5 : ((PatternGraphLhsNode)object).getHoms()) {
                set = HomStorage.getInheritedHomSet(set5, patternGraphLhsNode.getNodes(), patternGraphLhsNode.getEdges());
                HomStorage.addIfNonTrivialHomSet(this.homSets, set);
            }
        }
        this.initElementsToHomElements(patternGraphLhsNode.getNodes(), patternGraphLhsNode.getEdges());
    }

    private static Set<ConstraintDeclNode> getDeleteHomSet(Collection<? extends BaseNode> collection, Set<ConstraintDeclNode> set) {
        HashSet<ConstraintDeclNode> hashSet = new HashSet<ConstraintDeclNode>();
        for (BaseNode baseNode : collection) {
            ConstraintDeclNode constraintDeclNode = (ConstraintDeclNode)baseNode;
            if (!set.contains(constraintDeclNode)) continue;
            hashSet.add(constraintDeclNode);
        }
        return hashSet;
    }

    private static Set<ConstraintDeclNode> getReuseHomSet(Collection<? extends BaseNode> collection, Set<ConstraintDeclNode> set) {
        HashSet<ConstraintDeclNode> hashSet = new HashSet<ConstraintDeclNode>();
        for (BaseNode baseNode : collection) {
            ConstraintDeclNode constraintDeclNode = (ConstraintDeclNode)baseNode;
            if (set.contains(constraintDeclNode)) continue;
            hashSet.add(constraintDeclNode);
        }
        return hashSet;
    }

    private static Set<ConstraintDeclNode> getHomSet(Collection<? extends BaseNode> collection) {
        LinkedHashSet<ConstraintDeclNode> linkedHashSet = new LinkedHashSet<ConstraintDeclNode>();
        for (BaseNode baseNode : collection) {
            ConstraintDeclNode constraintDeclNode = (ConstraintDeclNode)baseNode;
            linkedHashSet.add(constraintDeclNode);
        }
        return linkedHashSet;
    }

    private static Set<ConstraintDeclNode> getInheritedHomSet(Set<ConstraintDeclNode> set, Set<NodeDeclNode> set2, Set<EdgeDeclNode> set3) {
        LinkedHashSet<ConstraintDeclNode> linkedHashSet = new LinkedHashSet<ConstraintDeclNode>();
        if (set.iterator().next() instanceof NodeDeclNode) {
            for (ConstraintDeclNode constraintDeclNode : set) {
                if (!set2.contains(constraintDeclNode)) continue;
                linkedHashSet.add(constraintDeclNode);
            }
        } else {
            for (ConstraintDeclNode constraintDeclNode : set) {
                if (!set3.contains(constraintDeclNode)) continue;
                linkedHashSet.add(constraintDeclNode);
            }
        }
        return linkedHashSet;
    }

    private static void addIfNonTrivialHomSet(Collection<Set<ConstraintDeclNode>> collection, Set<ConstraintDeclNode> set) {
        if (set.size() > 1) {
            collection.add(set);
        }
    }

    private void initElementsToHomElements(Set<NodeDeclNode> set, Set<EdgeDeclNode> set2) {
        LinkedHashSet<ConstraintDeclNode> linkedHashSet;
        for (NodeDeclNode object : set) {
            linkedHashSet = new LinkedHashSet<ConstraintDeclNode>();
            linkedHashSet.add(object);
            this.nodeToHomNodes.put(object, linkedHashSet);
        }
        for (EdgeDeclNode edgeDeclNode : set2) {
            linkedHashSet = new LinkedHashSet();
            linkedHashSet.add(edgeDeclNode);
            this.edgeToHomEdges.put(edgeDeclNode, linkedHashSet);
        }
        for (Set set3 : this.homSets) {
            if (set3.iterator().next() instanceof NodeDeclNode) {
                this.fillHomNodesInNodesToHomNodes(set3);
                continue;
            }
            this.fillHomEdgesInEdgesToHomEdges(set3);
        }
    }

    private void fillHomNodesInNodesToHomNodes(Set<ConstraintDeclNode> set) {
        for (ConstraintDeclNode constraintDeclNode : set) {
            NodeDeclNode nodeDeclNode = (NodeDeclNode)constraintDeclNode;
            Set<NodeDeclNode> set2 = this.nodeToHomNodes.get(nodeDeclNode);
            for (ConstraintDeclNode constraintDeclNode2 : set) {
                set2.add((NodeDeclNode)constraintDeclNode2);
            }
        }
    }

    private void fillHomEdgesInEdgesToHomEdges(Set<ConstraintDeclNode> set) {
        for (ConstraintDeclNode constraintDeclNode : set) {
            EdgeDeclNode edgeDeclNode = (EdgeDeclNode)constraintDeclNode;
            Set<EdgeDeclNode> set2 = this.edgeToHomEdges.get(edgeDeclNode);
            for (ConstraintDeclNode constraintDeclNode2 : set) {
                set2.add((EdgeDeclNode)constraintDeclNode2);
            }
        }
    }

    public Collection<Set<ConstraintDeclNode>> getHoms() {
        return this.homSets;
    }

    public Set<NodeDeclNode> getHomomorphic(NodeDeclNode nodeDeclNode) {
        Set<NodeDeclNode> set = this.nodeToHomNodes.get(nodeDeclNode);
        if (set == null) {
            return this.emptyHomNodeSet;
        }
        return set;
    }

    public Set<EdgeDeclNode> getHomomorphic(EdgeDeclNode edgeDeclNode) {
        Set<EdgeDeclNode> set = this.edgeToHomEdges.get(edgeDeclNode);
        if (set == null) {
            return this.emptyHomEdgeSet;
        }
        return set;
    }
}

