/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.DummyNodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeTypeChangeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.model.type.ArbitraryEdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.pattern.ConnectionCharacter;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.DeclaredTypeNode;
import de.unika.ipd.grgen.ast.util.Checker;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ast.util.TypeChecker;
import de.unika.ipd.grgen.ir.pattern.PatternGraphBase;
import java.util.Collection;
import java.util.Set;
import java.util.Vector;

public class ConnectionNode
extends ConnectionCharacter {
    private ConnectionKind connectionKind;
    public static final int NO_REDIRECTION = 0;
    public static final int REDIRECT_SOURCE = 1;
    public static final int REDIRECT_TARGET = 2;
    public static final int REDIRECT_SOURCE_AND_TARGET = 3;
    private int redirectionKind;
    private NodeDeclNode left;
    private EdgeDeclNode edge;
    private NodeDeclNode right;
    private BaseNode leftUnresolved;
    public BaseNode edgeUnresolved;
    private BaseNode rightUnresolved;
    private static DeclarationResolver<NodeDeclNode> nodeResolver;
    private static DeclarationResolver<EdgeDeclNode> edgeResolver;
    private static Checker nodeTypeChecker;
    private static Checker edgeTypeChecker;

    public ConnectionNode(BaseNode baseNode, BaseNode baseNode2, BaseNode baseNode3, ConnectionKind connectionKind, int n) {
        super(baseNode2.getCoords());
        this.leftUnresolved = baseNode;
        this.becomeParent(this.leftUnresolved);
        this.edgeUnresolved = baseNode2;
        this.becomeParent(this.edgeUnresolved);
        this.rightUnresolved = baseNode3;
        this.becomeParent(this.rightUnresolved);
        this.connectionKind = connectionKind;
        this.redirectionKind = n;
    }

    public ConnectionNode(NodeDeclNode nodeDeclNode, EdgeDeclNode edgeDeclNode, NodeDeclNode nodeDeclNode2, ConnectionKind connectionKind, BaseNode baseNode) {
        this((BaseNode)nodeDeclNode, (BaseNode)edgeDeclNode, (BaseNode)nodeDeclNode2, connectionKind, 0);
        baseNode.becomeParent(this);
        this.resolve();
        this.check();
    }

    public ConnectionNode cloneForAuto(PatternGraphLhsNode patternGraphLhsNode) {
        return new ConnectionNode(this.left.cloneForAuto(patternGraphLhsNode), this.edge.cloneForAuto(patternGraphLhsNode), this.right.cloneForAuto(patternGraphLhsNode), this.connectionKind, patternGraphLhsNode);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.leftUnresolved, this.left));
        vector.add(this.getValidVersion(this.edgeUnresolved, this.edge));
        vector.add(this.getValidVersion(this.rightUnresolved, this.right));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("src");
        vector.add("edge");
        vector.add("tgt");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = ConnectionNode.fixupDefinition(this.leftUnresolved, this.leftUnresolved.getScope());
        bl &= ConnectionNode.fixupDefinition(this.edgeUnresolved, this.edgeUnresolved.getScope());
        if (!(bl &= ConnectionNode.fixupDefinition(this.rightUnresolved, this.rightUnresolved.getScope()))) {
            return false;
        }
        this.left = (NodeDeclNode)nodeResolver.resolve(this.leftUnresolved, this);
        this.edge = (EdgeDeclNode)edgeResolver.resolve(this.edgeUnresolved, this);
        this.right = (NodeDeclNode)nodeResolver.resolve(this.rightUnresolved, this);
        return this.left != null && this.edge != null && this.right != null;
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = nodeTypeChecker.check(this.left, error) & edgeTypeChecker.check(this.edge, error) & nodeTypeChecker.check(this.right, error) & this.checkEdgeRootType() & this.areDanglingEdgesInReplacementDeclaredInPattern() & this.noDefNonDefMixedConnection() & this.checkDeclaredOnLHS();
        if (!bl) {
            return false;
        }
        this.warnArbitraryRootType();
        return true;
    }

    private void warnArbitraryRootType() {
        if (this.connectionKind != ConnectionKind.ARBITRARY) {
            return;
        }
        if (!(this.edge.getDeclType() instanceof ArbitraryEdgeTypeNode)) {
            this.edge.reportWarning("The type of edge" + this.edge.emptyWhenAnonymousPostfix(" ") + " differs from " + this.getArbitraryEdgeRootTypeDecl().getIdentNode() + ", please use another edge kind instead of ?--? (e.g. -->).");
        }
    }

    private boolean checkEdgeRootType() {
        DeclaredTypeNode declaredTypeNode;
        TypeDeclNode typeDeclNode = null;
        switch (this.connectionKind) {
            case ARBITRARY: {
                typeDeclNode = this.getArbitraryEdgeRootTypeDecl();
                break;
            }
            case ARBITRARY_DIRECTED: {
                typeDeclNode = this.getDirectedEdgeRootTypeDecl();
                break;
            }
            case DIRECTED: {
                typeDeclNode = this.getDirectedEdgeRootTypeDecl();
                break;
            }
            case UNDIRECTED: {
                typeDeclNode = this.getUndirectedEdgeRootTypeDecl();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        DeclaredTypeNode declaredTypeNode2 = declaredTypeNode = typeDeclNode != null ? typeDeclNode.getDeclType() : null;
        if (!this.edge.getDeclType().isCompatibleTo(declaredTypeNode)) {
            this.reportError("The connection kind of the edge" + this.edge.emptyWhenAnonymousPostfix(" ") + " is incompatible with the type of the edge (" + ConnectionNode.toString(this.connectionKind) + " with " + this.edge.getDeclType().toStringWithDeclarationCoords() + ").");
            return false;
        }
        return true;
    }

    private boolean areDanglingEdgesInReplacementDeclaredInPattern() {
        if (!(this.left instanceof DummyNodeDeclNode) && !(this.right instanceof DummyNodeDeclNode)) {
            return true;
        }
        if (this.left instanceof DummyNodeDeclNode && (this.left.context & 1) == 0) {
            return true;
        }
        if (this.right instanceof DummyNodeDeclNode && (this.right.context & 1) == 0) {
            return true;
        }
        if ((this.edge.context & 1) == 0) {
            return true;
        }
        if (this.edge instanceof EdgeTypeChangeDeclNode) {
            return true;
        }
        if (this.edge.defEntityToBeYieldedTo) {
            return true;
        }
        this.edge.reportError("Dangling edges in the rewrite part must have been declared in the pattern part" + this.edge.emptyWhenAnonymous(" (a declaration in the pattern part is missing for " + this.edge.getIdentNode() + ")") + ".");
        return false;
    }

    private boolean noDefNonDefMixedConnection() {
        if (this.left.defEntityToBeYieldedTo && (this.left.context & 1) == 0 && (this.edge.context & 1) == 0) {
            this.left.reportError("A pattern part def node cannot connect to a pattern part non-def edge (as is the case with " + this.left.getIdentNode() + " and " + this.edge.toStringWithDeclarationCoords() + ").");
            return false;
        }
        if (this.right.defEntityToBeYieldedTo && (this.right.context & 1) == 0 && (this.edge.context & 1) == 0) {
            this.right.reportError("A pattern part def node cannot connect to a pattern part non-def edge (as is the case with " + this.right.getIdentNode() + " and " + this.edge.toStringWithDeclarationCoords() + ").");
            return false;
        }
        if (!(!this.edge.defEntityToBeYieldedTo || (this.edge.context & 1) != 0 || this.left instanceof DummyNodeDeclNode && this.right instanceof DummyNodeDeclNode)) {
            this.edge.reportError("A pattern part def edge cannot connect to nodes at all (as is the case with " + this.edge.getIdentNode() + (this.left instanceof DummyNodeDeclNode ? "" : " and " + this.left.getIdentNode()) + (this.right instanceof DummyNodeDeclNode ? "" : " and " + this.right.getIdentNode()) + ").");
            return false;
        }
        return true;
    }

    private boolean checkDeclaredOnLHS() {
        if (this.redirectionKind != 0) {
            if ((this.edge.context & 1) == 1) {
                this.edge.reportError("An edge to be redirected must have been declared in the pattern (thus matched) (but edge " + this.edge.getIdentNode() + " is declared in the rewrite part).");
                return false;
            }
            if (this.connectionKind != ConnectionKind.DIRECTED) {
                this.edge.reportError("Only directed edges may be redirected (to other nodes) (this is not the case for edge " + this.edge.getIdentNode() + " of connection kind " + ConnectionNode.toString(this.connectionKind) + ").");
                return false;
            }
        }
        if (this.connectionKind == ConnectionKind.ARBITRARY && (this.edge.context & 1) == 1) {
            this.edge.reportError("New instances of ?--? are not allowed in the rewrite part" + this.edge.emptyWhenAnonymous(" (this is the case for edge " + this.edge.getIdentNode() + ")") + ".");
            return false;
        }
        if (this.connectionKind == ConnectionKind.ARBITRARY_DIRECTED && (this.edge.context & 1) == 1) {
            this.edge.reportError("New instances of <--> are not allowed in the rewrite part" + this.edge.emptyWhenAnonymous(" (this is the case for edge " + this.edge.getIdentNode() + ")") + ".");
            return false;
        }
        return true;
    }

    @Override
    public void addToGraph(PatternGraphBase patternGraphBase) {
        patternGraphBase.addConnection(this.left.getNode(), this.edge.getEdge(), this.right.getNode(), this.connectionKind == ConnectionKind.DIRECTED, (this.redirectionKind & 1) == 1, (this.redirectionKind & 2) == 2);
    }

    @Override
    public void addEdge(Set<EdgeDeclNode> set) {
        assert (this.isResolved());
        set.add(this.edge);
    }

    public ConnectionKind getConnectionKind() {
        return this.connectionKind;
    }

    public int getRedirectionKind() {
        return this.redirectionKind;
    }

    @Override
    public EdgeDeclNode getEdge() {
        return this.edge;
    }

    @Override
    public NodeDeclNode getSrc() {
        return this.left;
    }

    @Override
    public void setSrc(NodeDeclNode nodeDeclNode) {
        assert (nodeDeclNode != null);
        this.switchParenthood(this.left, nodeDeclNode);
        this.left = nodeDeclNode;
    }

    @Override
    public NodeDeclNode getTgt() {
        return this.right;
    }

    @Override
    public void setTgt(NodeDeclNode nodeDeclNode) {
        assert (nodeDeclNode != null);
        this.switchParenthood(this.right, nodeDeclNode);
        this.right = nodeDeclNode;
    }

    @Override
    public void addNodes(Set<NodeDeclNode> set) {
        assert (this.isResolved());
        set.add(this.left);
        set.add(this.right);
    }

    public static String getKindStr() {
        return "connection node";
    }

    public static String toString(ConnectionKind connectionKind) {
        switch (connectionKind) {
            case ARBITRARY: {
                return "?--?";
            }
            case ARBITRARY_DIRECTED: {
                return "<-->";
            }
            case DIRECTED: {
                return "-->";
            }
            case UNDIRECTED: {
                return "--";
            }
        }
        throw new RuntimeException("Internal compiler error -- unkonwn connection kind.");
    }

    static {
        ConnectionNode.setName(ConnectionNode.class, "connection");
        nodeResolver = new DeclarationResolver<NodeDeclNode>(NodeDeclNode.class);
        edgeResolver = new DeclarationResolver<EdgeDeclNode>(EdgeDeclNode.class);
        nodeTypeChecker = new TypeChecker(NodeTypeNode.class);
        edgeTypeChecker = new TypeChecker(EdgeTypeNode.class);
    }

    public static enum ConnectionKind {
        ARBITRARY,
        ARBITRARY_DIRECTED,
        DIRECTED,
        UNDIRECTED;

    }
}

