/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.model.type;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.type.CompoundTypeNode;
import de.unika.ipd.grgen.ast.util.CollectResolver;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.Ident;
import de.unika.ipd.grgen.ir.model.type.PackageType;
import java.util.Collection;
import java.util.Vector;

public class PackageTypeNode
extends CompoundTypeNode {
    private CollectNode<IdentNode> declsUnresolved;
    protected CollectNode<TypeDeclNode> decls;
    private static CollectResolver<TypeDeclNode> declsResolver;

    public PackageTypeNode(CollectNode<IdentNode> collectNode) {
        this.declsUnresolved = collectNode;
        this.becomeParent(this.declsUnresolved);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.declsUnresolved, this.decls));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("decls");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.decls = declsResolver.resolve(this.declsUnresolved, this);
        return this.decls != null;
    }

    public CollectNode<TypeDeclNode> getTypeDecls() {
        return this.decls;
    }

    @Override
    protected IR constructIR() {
        Ident ident = this.getIdentNode().checkIR(Ident.class);
        PackageType packageType = new PackageType(ident);
        for (TypeDeclNode typeDeclNode : this.decls.getChildren()) {
            packageType.addType(typeDeclNode.getDeclType().getType());
        }
        return packageType;
    }

    @Override
    public String toString() {
        return "package " + this.getIdentNode();
    }

    public static String getKindStr() {
        return "package";
    }

    static {
        PackageTypeNode.setName(PackageTypeNode.class, "package type");
        declsResolver = new CollectResolver<TypeDeclNode>(new DeclarationResolver<TypeDeclNode>(TypeDeclNode.class));
    }
}

