/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.model.type;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ExternalFunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ExternalProcedureDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorEvaluator;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.util.CollectResolver;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.ExternalFunctionMethod;
import de.unika.ipd.grgen.ir.executable.ExternalProcedureMethod;
import de.unika.ipd.grgen.ir.model.type.ExternalObjectType;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;

public class ExternalObjectTypeNode
extends InheritanceTypeNode {
    private CollectNode<ExternalObjectTypeNode> extend;
    private static final CollectResolver<ExternalObjectTypeNode> extendResolver;
    private static final CollectResolver<BaseNode> bodyResolver;

    public ExternalObjectTypeNode(CollectNode<IdentNode> collectNode, CollectNode<BaseNode> collectNode2) {
        this.extendUnresolved = collectNode;
        this.becomeParent(this.extendUnresolved);
        this.bodyUnresolved = collectNode2;
        this.becomeParent(this.bodyUnresolved);
        OperatorDeclNode.makeOp(OperatorDeclNode.Operator.COND, this, new TypeNode[]{BasicTypeNode.booleanType, this, this}, OperatorEvaluator.condEvaluator);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.extendUnresolved, this.extend));
        vector.add(this.getValidVersion(this.bodyUnresolved, this.body));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("extends");
        vector.add("body");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        OperatorDeclNode.makeOp(OperatorDeclNode.Operator.COND, this, new TypeNode[]{BasicTypeNode.booleanType, this, this}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.EQ, BasicTypeNode.booleanType, this, this, OperatorEvaluator.emptyEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.NE, BasicTypeNode.booleanType, this, this, OperatorEvaluator.emptyEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.GE, BasicTypeNode.booleanType, this, this, OperatorEvaluator.emptyEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.GT, BasicTypeNode.booleanType, this, this, OperatorEvaluator.emptyEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.LE, BasicTypeNode.booleanType, this, this, OperatorEvaluator.emptyEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.LT, BasicTypeNode.booleanType, this, this, OperatorEvaluator.emptyEvaluator);
        this.body = bodyResolver.resolve(this.bodyUnresolved, this);
        this.extend = extendResolver.resolve(this.extendUnresolved, this);
        if (this.extend != null) {
            for (InheritanceTypeNode inheritanceTypeNode : this.extend.getChildren()) {
                inheritanceTypeNode.addDirectSubType(this);
            }
        }
        return this.body != null && this.extend != null;
    }

    protected ExternalObjectType getExternalObjectType() {
        return this.checkIR(ExternalObjectType.class);
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        ExternalObjectType externalObjectType = new ExternalObjectType(this.getDecl().getIdentNode().getIdent());
        this.setIR(externalObjectType);
        this.constructIR(externalObjectType);
        return externalObjectType;
    }

    protected void constructIR(ExternalObjectType externalObjectType) {
        for (BaseNode baseNode : this.body.getChildren()) {
            if (baseNode instanceof ExternalFunctionDeclNode) {
                externalObjectType.addExternalFunctionMethod(baseNode.checkIR(ExternalFunctionMethod.class));
                continue;
            }
            externalObjectType.addExternalProcedureMethod(baseNode.checkIR(ExternalProcedureMethod.class));
        }
        for (InheritanceTypeNode inheritanceTypeNode : this.getExtends().getChildren()) {
            externalObjectType.addDirectSuperType(inheritanceTypeNode.getType());
        }
    }

    @Override
    protected CollectNode<? extends InheritanceTypeNode> getExtends() {
        return this.extend;
    }

    @Override
    public void doGetCompatibleToTypes(Collection<TypeNode> collection) {
        assert (this.isResolved());
        for (ExternalObjectTypeNode externalObjectTypeNode : this.extend.getChildren()) {
            collection.add(externalObjectTypeNode);
            collection.addAll(externalObjectTypeNode.getCompatibleToTypes());
        }
    }

    public static String getKindStr() {
        return "external class";
    }

    public Collection<ExternalObjectTypeNode> getDirectSuperTypes() {
        assert (this.isResolved());
        return this.extend.getChildren();
    }

    @Override
    protected void getMembers(Map<String, DeclNode> map) {
        for (BaseNode baseNode : this.body.getChildren()) {
            DeclNode declNode;
            if (baseNode instanceof ExternalFunctionDeclNode) {
                declNode = (ExternalFunctionDeclNode)baseNode;
                this.checkExternalFunctionOverride((ExternalFunctionDeclNode)declNode);
                continue;
            }
            if (!(baseNode instanceof ExternalProcedureDeclNode)) continue;
            declNode = (ExternalProcedureDeclNode)baseNode;
            this.checkExternalProcedureOverride((ExternalProcedureDeclNode)declNode);
        }
    }

    private void checkExternalFunctionOverride(ExternalFunctionDeclNode externalFunctionDeclNode) {
        for (InheritanceTypeNode inheritanceTypeNode : this.getAllSuperTypes()) {
            for (BaseNode baseNode : inheritanceTypeNode.getBody().getChildren()) {
                if (!(baseNode instanceof ExternalFunctionDeclNode)) continue;
                ExternalFunctionDeclNode externalFunctionDeclNode2 = (ExternalFunctionDeclNode)baseNode;
                if (!externalFunctionDeclNode.ident.toString().equals(externalFunctionDeclNode2.ident.toString())) continue;
                ExternalObjectTypeNode.checkSignatureAdhered(externalFunctionDeclNode2, externalFunctionDeclNode);
            }
        }
    }

    private void checkExternalProcedureOverride(ExternalProcedureDeclNode externalProcedureDeclNode) {
        for (InheritanceTypeNode inheritanceTypeNode : this.getAllSuperTypes()) {
            for (BaseNode baseNode : inheritanceTypeNode.getBody().getChildren()) {
                if (!(baseNode instanceof ExternalProcedureDeclNode)) continue;
                ExternalProcedureDeclNode externalProcedureDeclNode2 = (ExternalProcedureDeclNode)baseNode;
                if (!externalProcedureDeclNode.ident.toString().equals(externalProcedureDeclNode2.ident.toString())) continue;
                ExternalObjectTypeNode.checkSignatureAdhered(externalProcedureDeclNode2, externalProcedureDeclNode);
            }
        }
    }

    static {
        ExternalObjectTypeNode.setName(ExternalObjectTypeNode.class, "external object type");
        extendResolver = new CollectResolver<ExternalObjectTypeNode>(new DeclarationTypeResolver<ExternalObjectTypeNode>(ExternalObjectTypeNode.class));
        bodyResolver = new CollectResolver(new DeclarationResolver(ExternalFunctionDeclNode.class, ExternalProcedureDeclNode.class));
    }
}

