/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.model.type;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorEvaluator;
import de.unika.ipd.grgen.ast.model.decl.EnumItemDeclNode;
import de.unika.ipd.grgen.ast.type.CompoundTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.Ident;
import de.unika.ipd.grgen.ir.model.EnumItem;
import de.unika.ipd.grgen.ir.model.type.EnumType;
import java.util.Collection;
import java.util.Vector;

public class EnumTypeNode
extends CompoundTypeNode {
    private CollectNode<EnumItemDeclNode> elements;

    public EnumTypeNode(CollectNode<EnumItemDeclNode> collectNode) {
        this.elements = collectNode;
        this.becomeParent(this.elements);
        OperatorDeclNode.makeOp(OperatorDeclNode.Operator.COND, this, new TypeNode[]{BasicTypeNode.booleanType, this, this}, OperatorEvaluator.condEvaluator);
        EnumTypeNode.addCompatibility(this, BasicTypeNode.byteType);
        EnumTypeNode.addCompatibility(this, BasicTypeNode.shortType);
        EnumTypeNode.addCompatibility(this, BasicTypeNode.intType);
        EnumTypeNode.addCompatibility(this, BasicTypeNode.longType);
        EnumTypeNode.addCompatibility(this, BasicTypeNode.floatType);
        EnumTypeNode.addCompatibility(this, BasicTypeNode.doubleType);
        EnumTypeNode.addCompatibility(this, BasicTypeNode.stringType);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.elements);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("elements");
        return vector;
    }

    @Override
    protected IR constructIR() {
        Ident ident = this.getIdentNode().checkIR(Ident.class);
        EnumType enumType = new EnumType(ident);
        for (EnumItemDeclNode enumItemDeclNode : this.elements.getChildren()) {
            EnumItem enumItem = enumItemDeclNode.getItem();
            enumItem.getValue().lateInit(enumType, enumItem);
            enumType.addItem(enumItem);
        }
        return enumType;
    }

    @Override
    public String toString() {
        return "enum " + this.getIdentNode().toString();
    }

    public static String getKindStr() {
        return "enum";
    }

    static {
        EnumTypeNode.setName(EnumTypeNode.class, "enum type");
    }
}

