/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.model.decl;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ExternalFunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ExternalProcedureDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorEvaluator;
import de.unika.ipd.grgen.ast.model.decl.IndexDeclNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.ExternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalTransientObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.ModelTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.DeclaredTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.util.CollectResolver;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.Ident;
import de.unika.ipd.grgen.ir.executable.ExternalFunction;
import de.unika.ipd.grgen.ir.executable.ExternalProcedure;
import de.unika.ipd.grgen.ir.model.Index;
import de.unika.ipd.grgen.ir.model.Model;
import de.unika.ipd.grgen.ir.model.type.PackageType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;

public class ModelNode
extends DeclNode {
    private static final TypeNode modelType;
    private CollectNode<ModelNode> usedModels;
    private CollectNode<IdentNode> packagesUnresolved;
    protected CollectNode<TypeDeclNode> packages;
    private CollectNode<IdentNode> declsUnresolved;
    public CollectNode<TypeDeclNode> decls;
    private CollectNode<IdentNode> externalFuncDeclsUnresolved;
    protected CollectNode<ExternalFunctionDeclNode> externalFuncDecls;
    private CollectNode<IdentNode> externalProcDeclsUnresolved;
    protected CollectNode<ExternalProcedureDeclNode> externalProcDecls;
    private CollectNode<IdentNode> indicesUnresolved;
    protected CollectNode<IndexDeclNode> indices;
    private ModelTypeNode type;
    private boolean isEmitClassDefined;
    private boolean isEmitGraphClassDefined;
    private boolean isCopyClassDefined;
    private boolean isEqualClassDefined;
    private boolean isLowerClassDefined;
    private boolean isGraphofDefined;
    private boolean isUniqueDefined;
    private boolean isUniqueClassDefined;
    private boolean isUniqueIndexDefined;
    private boolean areFunctionsParallel;
    private int isoParallel;
    private int sequencesParallel;
    private static CollectResolver<TypeDeclNode> packagesResolver;
    private static CollectResolver<TypeDeclNode> declsResolver;
    private static CollectResolver<IndexDeclNode> indicesResolver;
    private static CollectResolver<ExternalFunctionDeclNode> externalFunctionsResolver;
    private static CollectResolver<ExternalProcedureDeclNode> externalProceduresResolver;
    private static DeclarationTypeResolver<ModelTypeNode> typeResolver;

    public ModelNode(IdentNode identNode, CollectNode<IdentNode> collectNode, CollectNode<IdentNode> collectNode2, CollectNode<IdentNode> collectNode3, CollectNode<IdentNode> collectNode4, CollectNode<IdentNode> collectNode5, CollectNode<ModelNode> collectNode6, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, int n, int n2) {
        super(identNode, modelType);
        this.packagesUnresolved = collectNode;
        this.becomeParent(this.packagesUnresolved);
        this.declsUnresolved = collectNode2;
        this.becomeParent(this.declsUnresolved);
        this.externalFuncDeclsUnresolved = collectNode3;
        this.becomeParent(this.externalFuncDeclsUnresolved);
        this.externalProcDeclsUnresolved = collectNode4;
        this.becomeParent(this.externalProcDeclsUnresolved);
        this.indicesUnresolved = collectNode5;
        this.becomeParent(this.indicesUnresolved);
        this.usedModels = collectNode6;
        this.becomeParent(this.usedModels);
        this.isEmitClassDefined = bl;
        this.isEmitGraphClassDefined = bl2;
        this.isCopyClassDefined = bl3;
        this.isEqualClassDefined = bl4;
        this.isLowerClassDefined = bl5;
        this.isGraphofDefined = bl6;
        this.isUniqueDefined = bl7;
        this.isUniqueClassDefined = bl8;
        this.isUniqueIndexDefined = bl9;
        this.areFunctionsParallel = bl10;
        this.isoParallel = n;
        this.sequencesParallel = n2;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.type));
        vector.add(this.getValidVersion(this.packagesUnresolved, this.packages));
        vector.add(this.getValidVersion(this.declsUnresolved, this.decls));
        vector.add(this.getValidVersion(this.externalFuncDeclsUnresolved, this.externalFuncDecls));
        vector.add(this.getValidVersion(this.externalProcDeclsUnresolved, this.externalProcDecls));
        vector.add(this.getValidVersion(this.indicesUnresolved, this.indices));
        vector.add(this.usedModels);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("packages");
        vector.add("decls");
        vector.add("externalFuncDecls");
        vector.add("externalProcDecls");
        vector.add("indices");
        vector.add("usedModels");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (this.isLowerClassDefined) {
            OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.GE, BasicTypeNode.booleanType, BasicTypeNode.objectType, BasicTypeNode.objectType, OperatorEvaluator.objectEvaluator);
            OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.GT, BasicTypeNode.booleanType, BasicTypeNode.objectType, BasicTypeNode.objectType, OperatorEvaluator.objectEvaluator);
            OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.LE, BasicTypeNode.booleanType, BasicTypeNode.objectType, BasicTypeNode.objectType, OperatorEvaluator.objectEvaluator);
            OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.LT, BasicTypeNode.booleanType, BasicTypeNode.objectType, BasicTypeNode.objectType, OperatorEvaluator.objectEvaluator);
        }
        this.packages = packagesResolver.resolve(this.packagesUnresolved, this);
        this.decls = declsResolver.resolve(this.declsUnresolved, this);
        this.indices = indicesResolver.resolve(this.indicesUnresolved, this);
        this.externalFuncDecls = externalFunctionsResolver.resolve(this.externalFuncDeclsUnresolved, this);
        this.externalProcDecls = externalProceduresResolver.resolve(this.externalProcDeclsUnresolved, this);
        this.type = (ModelTypeNode)typeResolver.resolve(this.typeUnresolved, this);
        return this.decls != null && this.externalFuncDecls != null && this.externalProcDecls != null && this.type != null;
    }

    @Override
    protected boolean checkLocal() {
        return this.checkInhCycleFree() && this.equalityMustBeDefinedIfLowerIsDefined();
    }

    public boolean IsEmitClassDefined() {
        return this.isEmitClassDefined;
    }

    public boolean IsEmitGraphClassDefined() {
        return this.isEmitGraphClassDefined;
    }

    public boolean IsCopyClassDefined() {
        return this.isCopyClassDefined;
    }

    public boolean IsEqualClassDefined() {
        return this.isEqualClassDefined;
    }

    public boolean IsLowerClassDefined() {
        return this.isLowerClassDefined;
    }

    public boolean IsGraphofDefined() {
        return this.isGraphofDefined;
    }

    public boolean IsUniqueDefined() {
        return this.isUniqueDefined;
    }

    public boolean IsUniqueClassDefined() {
        return this.isUniqueClassDefined;
    }

    public boolean IsUniqueIndexDefined() {
        return this.isUniqueIndexDefined;
    }

    public boolean AreFunctionsParallel() {
        return this.areFunctionsParallel;
    }

    public int IsoParallel() {
        return this.isoParallel;
    }

    public int SequencesParallel() {
        return this.sequencesParallel;
    }

    public CollectNode<TypeDeclNode> getTypeDecls() {
        return this.decls;
    }

    public CollectNode<IndexDeclNode> getIndices() {
        return this.indices;
    }

    public CollectNode<ModelNode> getUsedModels() {
        return this.usedModels;
    }

    public CollectNode<TypeDeclNode> getPackages() {
        return this.packages;
    }

    public Model getModel() {
        return this.checkIR(Model.class);
    }

    @Override
    protected Model constructIR() {
        Ident ident = this.ident.checkIR(Ident.class);
        Model model = new Model(ident, this.isEmitClassDefined, this.isEmitGraphClassDefined, this.isCopyClassDefined, this.isEqualClassDefined, this.isLowerClassDefined, this.isGraphofDefined, this.isUniqueDefined, this.isUniqueClassDefined, this.isUniqueIndexDefined, this.areFunctionsParallel, this.isoParallel, this.sequencesParallel);
        for (ModelNode declNode : this.usedModels.getChildren()) {
            model.addUsedModel(declNode.getModel());
        }
        for (TypeDeclNode typeDeclNode : this.packages.getChildren()) {
            model.addPackage((PackageType)typeDeclNode.getDeclType().getType());
        }
        for (TypeDeclNode typeDeclNode : this.decls.getChildren()) {
            model.addType(typeDeclNode.getDeclType().getType());
        }
        for (IndexDeclNode indexDeclNode : this.indices.getChildren()) {
            model.addIndex(indexDeclNode.checkIR(Index.class));
        }
        for (ExternalFunctionDeclNode externalFunctionDeclNode : this.externalFuncDecls.getChildren()) {
            model.addExternalFunction(externalFunctionDeclNode.checkIR(ExternalFunction.class));
        }
        for (ExternalProcedureDeclNode externalProcedureDeclNode : this.externalProcDecls.getChildren()) {
            model.addExternalProcedure(externalProcedureDeclNode.checkIR(ExternalProcedure.class));
        }
        return model;
    }

    private boolean checkInhCycleFree_rec(InheritanceTypeNode inheritanceTypeNode, Collection<BaseNode> collection, Collection<BaseNode> collection2) {
        collection.add(inheritanceTypeNode);
        for (BaseNode baseNode : inheritanceTypeNode.getDirectSuperTypes()) {
            if (!(baseNode instanceof InheritanceTypeNode)) continue;
            assert (inheritanceTypeNode instanceof NodeTypeNode && baseNode instanceof NodeTypeNode || inheritanceTypeNode instanceof EdgeTypeNode && baseNode instanceof EdgeTypeNode || inheritanceTypeNode instanceof InternalObjectTypeNode && baseNode instanceof InternalObjectTypeNode || inheritanceTypeNode instanceof InternalTransientObjectTypeNode && baseNode instanceof InternalTransientObjectTypeNode || inheritanceTypeNode instanceof ExternalObjectTypeNode && baseNode instanceof ExternalObjectTypeNode) : "nodes should extend nodes and edges should extend edges";
            InheritanceTypeNode inheritanceTypeNode2 = (InheritanceTypeNode)baseNode;
            if (collection.contains(inheritanceTypeNode2)) {
                inheritanceTypeNode.getIdentNode().reportError("The class " + inheritanceTypeNode.getTypeName() + " extends " + inheritanceTypeNode2.toStringWithDeclarationCoords() + " - this introduces a cycle into the type hierarchy.");
                return false;
            }
            if (collection2.contains(inheritanceTypeNode2) || this.checkInhCycleFree_rec(inheritanceTypeNode2, collection, collection2)) continue;
            return false;
        }
        collection.remove(inheritanceTypeNode);
        collection2.add(inheritanceTypeNode);
        return true;
    }

    private boolean checkInhCycleFree() {
        Collection<TypeDeclNode> collection = this.decls.getChildren();
        for (TypeDeclNode typeDeclNode : collection) {
            HashSet<BaseNode> hashSet;
            HashSet<BaseNode> hashSet2;
            boolean bl;
            DeclaredTypeNode declaredTypeNode = typeDeclNode.getDeclType();
            if (!(declaredTypeNode instanceof InheritanceTypeNode) || (bl = this.checkInhCycleFree_rec((InheritanceTypeNode)declaredTypeNode, hashSet2 = new HashSet<BaseNode>(), hashSet = new HashSet<BaseNode>()))) continue;
            return false;
        }
        return true;
    }

    private boolean equalityMustBeDefinedIfLowerIsDefined() {
        if (this.isLowerClassDefined && !this.isEqualClassDefined) {
            this.reportError("A \"< class;\" requires a \"== class;\"");
            return false;
        }
        return true;
    }

    @Override
    public ModelTypeNode getDeclType() {
        assert (this.isResolved());
        return this.type;
    }

    static {
        ModelNode.setName(ModelNode.class, "model declaration");
        modelType = new ModelTypeNode();
        packagesResolver = new CollectResolver<TypeDeclNode>(new DeclarationResolver<TypeDeclNode>(TypeDeclNode.class));
        declsResolver = new CollectResolver<TypeDeclNode>(new DeclarationResolver<TypeDeclNode>(TypeDeclNode.class));
        indicesResolver = new CollectResolver<IndexDeclNode>(new DeclarationResolver<IndexDeclNode>(IndexDeclNode.class));
        externalFunctionsResolver = new CollectResolver<ExternalFunctionDeclNode>(new DeclarationResolver<ExternalFunctionDeclNode>(ExternalFunctionDeclNode.class));
        externalProceduresResolver = new CollectResolver<ExternalProcedureDeclNode>(new DeclarationResolver<ExternalProcedureDeclNode>(ExternalProcedureDeclNode.class));
        typeResolver = new DeclarationTypeResolver<ModelTypeNode>(ModelTypeNode.class);
    }
}

