/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.model.decl;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.EnumTypeNode;
import de.unika.ipd.grgen.ast.model.type.ExternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalTransientObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.type.container.DequeTypeNode;
import de.unika.ipd.grgen.ast.type.container.MapTypeNode;
import de.unika.ipd.grgen.ast.type.container.SetTypeNode;
import de.unika.ipd.grgen.ast.util.Checker;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.ast.util.SimpleChecker;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.type.Type;
import java.util.Collection;
import java.util.Vector;

public class MemberDeclNode
extends DeclNode {
    public TypeNode type;
    private boolean isConst;
    private BaseNode constInitializer;
    private static final DeclarationTypeResolver<TypeNode> typeResolver;
    private static final Checker typeChecker;

    public MemberDeclNode(IdentNode identNode, BaseNode baseNode, boolean bl) {
        super(identNode, baseNode);
        this.isConst = bl;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.type));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        return vector;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public BaseNode getConstInitializer() {
        return this.constInitializer;
    }

    public void setConstInitializer(BaseNode baseNode) {
        this.constInitializer = baseNode;
    }

    @Override
    protected boolean resolveLocal() {
        if (this.typeUnresolved instanceof PackageIdentNode) {
            Resolver.resolveOwner((PackageIdentNode)this.typeUnresolved);
        } else if (this.typeUnresolved instanceof IdentNode) {
            MemberDeclNode.fixupDefinition((IdentNode)this.typeUnresolved, ((IdentNode)this.typeUnresolved).getScope().getIdentNode().getScope());
        }
        this.type = (TypeNode)typeResolver.resolve(this.typeUnresolved, this);
        return this.type != null;
    }

    @Override
    public TypeNode getDeclType() {
        assert (this.isResolved());
        return this.type;
    }

    @Override
    protected boolean checkLocal() {
        return typeChecker.check(this.type, error);
    }

    @Override
    protected IR constructIR() {
        Type type = this.getDeclType().checkIR(Type.class);
        return new Entity("entity", this.getIdentNode().getIdent(), type, this.isConst, false, 0);
    }

    public static String getKindStr() {
        return "member";
    }

    static {
        MemberDeclNode.setName(MemberDeclNode.class, "member declaration");
        typeResolver = new DeclarationTypeResolver<TypeNode>(TypeNode.class);
        typeChecker = new SimpleChecker(new Class[]{BasicTypeNode.class, EnumTypeNode.class, InternalObjectTypeNode.class, InternalTransientObjectTypeNode.class, ExternalObjectTypeNode.class, NodeTypeNode.class, EdgeTypeNode.class, MapTypeNode.class, SetTypeNode.class, ArrayTypeNode.class, DequeTypeNode.class});
    }
}

