/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.model.decl;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.expr.invocation.FunctionInvocationDecisionNode;
import de.unika.ipd.grgen.ast.model.decl.IndexDeclNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.IncidenceCountIndexTypeNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.IntTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.model.IncidenceCountIndex;
import de.unika.ipd.grgen.ir.model.type.EdgeType;
import de.unika.ipd.grgen.ir.model.type.NodeType;
import de.unika.ipd.grgen.parser.ParserEnvironment;
import de.unika.ipd.grgen.util.Direction;
import java.util.Collection;
import java.util.Vector;

public class IncidenceCountIndexDeclNode
extends IndexDeclNode {
    private String functionName;
    private Direction direction;
    private IdentNode startNodeTypeUnresolved;
    private InheritanceTypeNode startNodeType;
    private IdentNode incidentEdgeTypeUnresolved;
    private InheritanceTypeNode incidentEdgeType;
    private IdentNode adjacentNodeTypeUnresolved;
    private InheritanceTypeNode adjacentNodeType;
    private static final IncidenceCountIndexTypeNode incidenceCountIndexType;
    private static final DeclarationTypeResolver<InheritanceTypeNode> typeResolver;

    public IncidenceCountIndexDeclNode(IdentNode identNode, String string, IdentNode identNode2, IdentNode identNode3, IdentNode identNode4, ParserEnvironment parserEnvironment) {
        super(identNode, incidenceCountIndexType);
        this.functionName = string;
        this.startNodeTypeUnresolved = this.becomeParent(identNode2);
        this.incidentEdgeTypeUnresolved = this.becomeParent(identNode3 != null ? identNode3 : parserEnvironment.getDirectedEdgeRoot());
        this.adjacentNodeTypeUnresolved = this.becomeParent(identNode4 != null ? identNode4 : parserEnvironment.getNodeRoot());
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.startNodeTypeUnresolved, this.startNodeType));
        vector.add(this.getValidVersion(this.incidentEdgeTypeUnresolved, this.incidentEdgeType));
        vector.add(this.getValidVersion(this.adjacentNodeTypeUnresolved, this.adjacentNodeType));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("startNodeType");
        vector.add("incidentEdgeType");
        vector.add("adjacentNodeType");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (this.startNodeTypeUnresolved == null) {
            this.reportError(this.functionName + "() expects 1-3 parameters (but already the start node type is missing).");
            return false;
        }
        if (this.startNodeTypeUnresolved instanceof PackageIdentNode) {
            Resolver.resolveOwner((PackageIdentNode)this.startNodeTypeUnresolved);
        } else {
            IncidenceCountIndexDeclNode.fixupDefinition(this.startNodeTypeUnresolved, this.startNodeTypeUnresolved.getScope());
        }
        this.startNodeType = (InheritanceTypeNode)typeResolver.resolve(this.startNodeTypeUnresolved, this);
        if (this.startNodeType == null) {
            return false;
        }
        if (this.incidentEdgeTypeUnresolved instanceof PackageIdentNode) {
            Resolver.resolveOwner((PackageIdentNode)this.incidentEdgeTypeUnresolved);
        } else {
            IncidenceCountIndexDeclNode.fixupDefinition(this.incidentEdgeTypeUnresolved, this.incidentEdgeTypeUnresolved.getScope());
        }
        this.incidentEdgeType = (InheritanceTypeNode)typeResolver.resolve(this.incidentEdgeTypeUnresolved, this);
        if (this.incidentEdgeType == null) {
            return false;
        }
        if (this.adjacentNodeTypeUnresolved instanceof PackageIdentNode) {
            Resolver.resolveOwner((PackageIdentNode)this.adjacentNodeTypeUnresolved);
        } else {
            IncidenceCountIndexDeclNode.fixupDefinition(this.adjacentNodeTypeUnresolved, this.adjacentNodeTypeUnresolved.getScope());
        }
        this.adjacentNodeType = (InheritanceTypeNode)typeResolver.resolve(this.adjacentNodeTypeUnresolved, this);
        if (this.adjacentNodeType == null) {
            return false;
        }
        this.direction = FunctionInvocationDecisionNode.getDirection(this.functionName);
        if (this.direction == Direction.INVALID) {
            this.reportError(this.functionName + "() is not a valid incidence count index declaration, expected is one of the count incidence function names countIncoming|countOutgoing|countIncident.");
            return false;
        }
        return true;
    }

    @Override
    protected boolean checkLocal() {
        if (!(this.startNodeType instanceof NodeTypeNode)) {
            this.reportError("The incidence count function specification " + this.functionName + "() in the incidende count index " + this.ident + " declaration expects as 1. type (start node type) a node type, but is given type " + this.startNodeType.getTypeName() + ".");
            return false;
        }
        if (!(this.incidentEdgeType instanceof EdgeTypeNode)) {
            this.reportError("The incidence count function specification " + this.functionName + "() in the incidende count index " + this.ident + " declaration expects as 2. type (incident edge type) an edge type, but is given type " + this.incidentEdgeType.getTypeName() + ".");
            return false;
        }
        if (!(this.adjacentNodeType instanceof NodeTypeNode)) {
            this.reportError("The incidence count function specification " + this.functionName + "() in the incidende count index " + this.ident + " declaration expects as 3. type (adjacent node type) a node type, but is given type " + this.adjacentNodeType.getTypeName() + ".");
            return false;
        }
        return true;
    }

    @Override
    public TypeNode getDeclType() {
        assert (this.isResolved());
        return incidenceCountIndexType;
    }

    @Override
    public InheritanceTypeNode getType() {
        assert (this.isResolved());
        return this.startNodeType;
    }

    @Override
    public TypeNode getExpectedAccessType() {
        assert (this.isResolved());
        return IntTypeNode.intType;
    }

    @Override
    protected IR constructIR() {
        IncidenceCountIndex incidenceCountIndex = new IncidenceCountIndex(this.getIdentNode().toString(), this.getIdentNode().getIdent(), this.startNodeType.checkIR(NodeType.class), this.incidentEdgeType.checkIR(EdgeType.class), this.direction, this.adjacentNodeType.checkIR(NodeType.class));
        return incidenceCountIndex;
    }

    public static String getKindStr() {
        return "incidence count index";
    }

    static {
        IncidenceCountIndexDeclNode.setName(IncidenceCountIndexDeclNode.class, "incidence count index declaration");
        incidenceCountIndexType = new IncidenceCountIndexTypeNode();
        typeResolver = new DeclarationTypeResolver<InheritanceTypeNode>(InheritanceTypeNode.class);
    }
}

