/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.model.decl;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.EnumConstNode;
import de.unika.ipd.grgen.ast.expr.EnumExprNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.InvalidConstNode;
import de.unika.ipd.grgen.ast.model.decl.MemberDeclNode;
import de.unika.ipd.grgen.ast.model.type.EnumTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.model.EnumItem;
import de.unika.ipd.grgen.util.Walkable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;

public class EnumItemDeclNode
extends MemberDeclNode {
    private ExprNode value;
    private EnumConstNode constValue;
    private final int pos;
    private static final DeclarationTypeResolver<EnumTypeNode> typeResolver;

    public EnumItemDeclNode(IdentNode identNode, IdentNode identNode2, ExprNode exprNode, int n) {
        super(identNode, identNode2, true);
        this.value = exprNode;
        this.becomeParent(this.value);
        this.pos = n;
    }

    @Override
    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.type));
        vector.add(this.value);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("value");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.type = (TypeNode)typeResolver.resolve(this.typeUnresolved, this);
        return this.type != null;
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = super.checkLocal();
        HashSet<EnumItemDeclNode> hashSet = new HashSet<EnumItemDeclNode>();
        if (!this.checkValue(this.value, hashSet)) {
            return false;
        }
        ExprNode exprNode = this.value.evaluate();
        if (!(exprNode instanceof ConstNode)) {
            this.reportError("The enum item " + this.ident + " expects a constant initialization expression.");
            return false;
        }
        if (!exprNode.getType().isCompatibleTo(BasicTypeNode.intType)) {
            this.reportError("The enum item " + this.ident + " expects an initialization expression of type int, but is given an expression of type " + exprNode.getType().getTypeName() + ".");
            return false;
        }
        if (this.value != (exprNode = ((ConstNode)exprNode).castTo(BasicTypeNode.intType))) {
            if (exprNode instanceof InvalidConstNode) {
                this.reportError("The enum item " + this.ident + " cannot be casted to int (INTERNAL FAILURE).");
                return false;
            }
            this.switchParenthood(this.value, exprNode);
            this.value = exprNode;
        }
        return bl;
    }

    private boolean checkValue(Walkable walkable, HashSet<EnumItemDeclNode> hashSet) {
        EnumItemDeclNode enumItemDeclNode = null;
        if (walkable instanceof EnumItemDeclNode) {
            enumItemDeclNode = (EnumItemDeclNode)walkable;
            if (this.pos == enumItemDeclNode.pos) {
                this.reportError("The enum item " + this.ident + " is not allowed to depend on its own value.");
                return false;
            }
            if (this.pos < enumItemDeclNode.pos) {
                this.reportError("The enum item " + this.ident + " is not allowed to depend on a following one.");
                return false;
            }
            if (hashSet.contains(enumItemDeclNode)) {
                this.reportError("Circular dependency found on value of enum item " + enumItemDeclNode.getIdentNode() + ".");
                return false;
            }
            hashSet.add(enumItemDeclNode);
        } else {
            if (walkable instanceof EnumTypeNode) {
                return true;
            }
            if (walkable instanceof EnumExprNode) {
                return true;
            }
        }
        for (Walkable walkable2 : walkable.getWalkableChildren()) {
            if (this.checkValue(walkable2, hashSet)) continue;
            return false;
        }
        if (enumItemDeclNode != null) {
            hashSet.remove(enumItemDeclNode);
        }
        return true;
    }

    @Override
    public TypeNode getDeclType() {
        assert (this.isResolved());
        return this.type;
    }

    public ExprNode getValue() {
        if (this.constValue != null) {
            return this.constValue;
        }
        if (!(this.value instanceof ConstNode)) {
            return this.value;
        }
        Object object = ((ConstNode)this.value).getValue();
        int n = (Integer)object;
        debug.report(4, "result: " + this.value);
        this.constValue = new EnumConstNode(this.getCoords(), this.getIdentNode(), n);
        return this.constValue;
    }

    public final EnumItem getItem() {
        return this.checkIR(EnumItem.class);
    }

    @Override
    protected IR constructIR() {
        EnumConstNode enumConstNode = (EnumConstNode)this.getValue();
        return new EnumItem(this.ident.getIdent(), enumConstNode.getConstant());
    }

    public static String getKindStr() {
        return "enum item";
    }

    static {
        EnumItemDeclNode.setName(EnumItemDeclNode.class, "enum item decl");
        typeResolver = new DeclarationTypeResolver<EnumTypeNode>(EnumTypeNode.class);
    }
}

