/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.model;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayInitNode;
import de.unika.ipd.grgen.ast.expr.deque.DequeInitNode;
import de.unika.ipd.grgen.ast.expr.map.MapInitNode;
import de.unika.ipd.grgen.ast.expr.set.SetInitNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.MemberResolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.array.ArrayInit;
import de.unika.ipd.grgen.ir.expr.deque.DequeInit;
import de.unika.ipd.grgen.ir.expr.map.MapInit;
import de.unika.ipd.grgen.ir.expr.set.SetInit;
import de.unika.ipd.grgen.ir.model.MemberInit;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class MemberInitNode
extends BaseNode {
    private BaseNode lhsUnresolved;
    private DeclNode lhs;
    private ExprNode rhs;
    private static final MemberResolver<DeclNode> lhsResolver;

    public MemberInitNode(Coords coords, IdentNode identNode, ExprNode exprNode) {
        super(coords);
        this.lhsUnresolved = identNode;
        this.becomeParent(this.lhsUnresolved);
        this.rhs = exprNode;
        this.becomeParent(this.rhs);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.lhsUnresolved, this.lhs));
        vector.add(this.rhs);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("lhs");
        vector.add("rhs");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (!lhsResolver.resolve(this.lhsUnresolved)) {
            return false;
        }
        this.lhs = lhsResolver.getResult(DeclNode.class);
        return lhsResolver.finish();
    }

    @Override
    protected boolean checkLocal() {
        return this.typeCheckLocal();
    }

    private boolean typeCheckLocal() {
        TypeNode typeNode = this.lhs.getDeclType();
        TypeNode typeNode2 = this.rhs.getType();
        if (typeNode2.isEqual(typeNode)) {
            return true;
        }
        this.rhs = this.becomeParent(this.rhs.adjustType(typeNode, this.getCoords()));
        return this.rhs != ConstNode.getInvalid();
    }

    @Override
    protected IR constructIR() {
        if (this.rhs instanceof MapInitNode) {
            MapInit mapInit = this.rhs.checkIR(MapInit.class);
            mapInit.setMember(this.lhs.checkIR(Entity.class));
            return mapInit;
        }
        if (this.rhs instanceof SetInitNode) {
            SetInit setInit = this.rhs.checkIR(SetInit.class);
            setInit.setMember(this.lhs.checkIR(Entity.class));
            return setInit;
        }
        if (this.rhs instanceof ArrayInitNode) {
            ArrayInit arrayInit = this.rhs.checkIR(ArrayInit.class);
            arrayInit.setMember(this.lhs.checkIR(Entity.class));
            return arrayInit;
        }
        if (this.rhs instanceof DequeInitNode) {
            DequeInit dequeInit = this.rhs.checkIR(DequeInit.class);
            dequeInit.setMember(this.lhs.checkIR(Entity.class));
            return dequeInit;
        }
        this.rhs = this.rhs.evaluate();
        return new MemberInit(this.lhs.checkIR(Entity.class), this.rhs.checkIR(Expression.class));
    }

    public static String getKindStr() {
        return "member initialization";
    }

    static {
        MemberInitNode.setName(MemberInitNode.class, "member init");
        lhsResolver = new MemberResolver();
    }
}

