/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.string;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.string.StringSubstring;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class StringSubstringNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode stringExpr;
    private ExprNode startExpr;
    private ExprNode lengthExpr;

    public StringSubstringNode(Coords coords, ExprNode exprNode, ExprNode exprNode2, ExprNode exprNode3) {
        super(coords);
        this.stringExpr = this.becomeParent(exprNode);
        this.startExpr = this.becomeParent(exprNode2);
        this.lengthExpr = this.becomeParent(exprNode3);
    }

    public StringSubstringNode(Coords coords, ExprNode exprNode, ExprNode exprNode2) {
        super(coords);
        this.stringExpr = this.becomeParent(exprNode);
        this.startExpr = this.becomeParent(exprNode2);
        this.lengthExpr = null;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.stringExpr);
        vector.add(this.startExpr);
        if (this.lengthExpr != null) {
            vector.add(this.lengthExpr);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("string");
        vector.add("start");
        if (this.lengthExpr != null) {
            vector.add("length");
        }
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (!this.stringExpr.getType().isEqual(BasicTypeNode.stringType)) {
            this.stringExpr.reportError("The string function method substring can only be employed on an object of type string (but is employed on an object of type " + this.stringExpr.getType().getTypeName() + ").");
            return false;
        }
        if (!this.startExpr.getType().isEqual(BasicTypeNode.intType)) {
            this.startExpr.reportError("The string function method substring expects as 1. argument (startPosition) a value of type int (but is given a value of type " + this.startExpr.getType().getTypeName() + ").");
            return false;
        }
        if (this.lengthExpr != null && !this.lengthExpr.getType().isEqual(BasicTypeNode.intType)) {
            this.lengthExpr.reportError("The string function method substring expects as 2. argument (length) a value of type int (but is given a value of type " + this.lengthExpr.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.stringExpr = this.stringExpr.evaluate();
        this.startExpr = this.startExpr.evaluate();
        if (this.lengthExpr != null) {
            this.lengthExpr = this.lengthExpr.evaluate();
        }
        return new StringSubstring(this.stringExpr.checkIR(Expression.class), this.startExpr.checkIR(Expression.class), this.lengthExpr != null ? this.lengthExpr.checkIR(Expression.class) : null);
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.stringType;
    }

    static {
        StringSubstringNode.setName(StringSubstringNode.class, "string substring");
    }
}

