/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.string;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.string.StringStartsWith;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class StringStartsWithNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode stringExpr;
    private ExprNode stringToSearchForExpr;

    public StringStartsWithNode(Coords coords, ExprNode exprNode, ExprNode exprNode2) {
        super(coords);
        this.stringExpr = this.becomeParent(exprNode);
        this.stringToSearchForExpr = this.becomeParent(exprNode2);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.stringExpr);
        vector.add(this.stringToSearchForExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("string");
        vector.add("stringToSearchFor");
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (!this.stringExpr.getType().isEqual(BasicTypeNode.stringType)) {
            this.stringExpr.reportError("The string function method startsWith can only be employed on an object of type string (but is employed on an object of type " + this.stringExpr.getType().getTypeName() + ").");
            return false;
        }
        if (!this.stringToSearchForExpr.getType().isEqual(BasicTypeNode.stringType)) {
            this.stringToSearchForExpr.reportError("The string function method startsWith expects as argument (stringToSearchFor) a value of type string (but is given a value of type " + this.stringToSearchForExpr.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.stringExpr = this.stringExpr.evaluate();
        this.stringToSearchForExpr = this.stringToSearchForExpr.evaluate();
        return new StringStartsWith(this.stringExpr.checkIR(Expression.class), this.stringToSearchForExpr.checkIR(Expression.class));
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.booleanType;
    }

    static {
        StringStartsWithNode.setName(StringStartsWithNode.class, "string startsWith");
    }
}

