/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.string;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.string.StringLength;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class StringLengthNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode stringExpr;

    public StringLengthNode(Coords coords, ExprNode exprNode) {
        super(coords);
        this.stringExpr = this.becomeParent(exprNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.stringExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("string");
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (!this.stringExpr.getType().isEqual(BasicTypeNode.stringType)) {
            this.stringExpr.reportError("The string function method length can only be employed on an object of type string (but is employed on an object of type " + this.stringExpr.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.stringExpr = this.stringExpr.evaluate();
        return new StringLength(this.stringExpr.checkIR(Expression.class));
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.intType;
    }

    static {
        StringLengthNode.setName(StringLengthNode.class, "string length");
    }
}

