/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.string;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.basic.StringTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.string.StringAsArray;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class StringAsArrayNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode stringExpr;
    private ExprNode stringToSplitAtExpr;
    private ArrayTypeNode arrayTypeNode;

    public StringAsArrayNode(Coords coords, ExprNode exprNode, ExprNode exprNode2) {
        super(coords);
        this.stringExpr = this.becomeParent(exprNode);
        this.stringToSplitAtExpr = this.becomeParent(exprNode2);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.stringExpr);
        vector.add(this.stringToSplitAtExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("string");
        vector.add("stringToSplitAt");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.arrayTypeNode = new ArrayTypeNode(((StringTypeNode)this.stringExpr.getType()).getIdentNode());
        return this.arrayTypeNode.resolve();
    }

    @Override
    protected boolean checkLocal() {
        if (!this.stringExpr.getType().isEqual(BasicTypeNode.stringType)) {
            this.stringExpr.reportError("The string function method explode can only be employed on an object of type string (but is employed on an object of type " + this.stringExpr.getType().getTypeName() + ").");
            return false;
        }
        if (!this.stringToSplitAtExpr.getType().isEqual(BasicTypeNode.stringType)) {
            this.stringToSplitAtExpr.reportError("The string function method explode expects as argument (stringToSplitAt) a value of type string (but is given a value of type " + this.stringToSplitAtExpr.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.stringExpr = this.stringExpr.evaluate();
        this.stringToSplitAtExpr = this.stringToSplitAtExpr.evaluate();
        return new StringAsArray(this.stringExpr.checkIR(Expression.class), this.stringToSplitAtExpr.checkIR(Expression.class), this.getType().getType());
    }

    @Override
    public TypeNode getType() {
        return this.arrayTypeNode;
    }

    static {
        StringAsArrayNode.setName(StringAsArrayNode.class, "string asArray");
    }
}

