/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.set;

import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.set.SetFunctionMethodInvocationBaseExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.container.SetTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.set.SetMaxExpr;
import de.unika.ipd.grgen.parser.Coords;

public class SetMaxNode
extends SetFunctionMethodInvocationBaseExprNode {
    public SetMaxNode(Coords coords, ExprNode exprNode) {
        super(coords, exprNode);
    }

    @Override
    protected boolean checkLocal() {
        SetTypeNode setTypeNode = this.getTargetType();
        if (!setTypeNode.valueType.isAccumulatableType()) {
            this.targetExpr.reportError("The set function method max can only be employed on an object of type set<" + TypeNode.getAccumulatableTypesAsString() + "> (but is employed on an object of type " + setTypeNode.getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    public TypeNode getType() {
        SetTypeNode setTypeNode = this.getTargetType();
        return BasicTypeNode.getArrayAccumulationResultType(setTypeNode.valueType);
    }

    @Override
    protected IR constructIR() {
        this.targetExpr = this.targetExpr.evaluate();
        return new SetMaxExpr(this.targetExpr.checkIR(Expression.class));
    }

    static {
        SetMaxNode.setName(SetMaxNode.class, "set max");
    }
}

