/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.numeric;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.numeric.PowExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class PowExprNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode leftExpr;
    private ExprNode rightExpr;

    public PowExprNode(Coords coords, ExprNode exprNode, ExprNode exprNode2) {
        super(coords);
        this.leftExpr = this.becomeParent(exprNode);
        this.rightExpr = this.becomeParent(exprNode2);
    }

    public PowExprNode(Coords coords, ExprNode exprNode) {
        super(coords);
        this.rightExpr = this.becomeParent(exprNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        if (this.leftExpr != null) {
            vector.add(this.leftExpr);
        }
        vector.add(this.rightExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        if (this.leftExpr != null) {
            vector.add("left");
        }
        vector.add("right");
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (!this.rightExpr.getType().isEqual(BasicTypeNode.doubleType)) {
            this.reportError("The function Math::pow() expects as 1. argument a value of type double (but is given a value of type " + this.rightExpr.getType().getTypeName() + ").");
            return false;
        }
        if (this.leftExpr != null && !this.leftExpr.getType().isEqual(BasicTypeNode.doubleType)) {
            this.reportError("The function Math::pow() expects as 2. argument a value of type double (but is given a value of type " + this.leftExpr.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.rightExpr = this.rightExpr.evaluate();
        if (this.leftExpr != null) {
            this.leftExpr = this.leftExpr.evaluate();
            return new PowExpr(this.leftExpr.checkIR(Expression.class), this.rightExpr.checkIR(Expression.class));
        }
        return new PowExpr(this.rightExpr.checkIR(Expression.class));
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.doubleType;
    }

    static {
        PowExprNode.setName(PowExprNode.class, "pow expr");
    }
}

