/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.numeric;

import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.ByteConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.FloatConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.IntConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.LongConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.ShortConstNode;
import de.unika.ipd.grgen.ast.expr.string.StringConstNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.parser.Coords;

public class DoubleConstNode
extends ConstNode {
    public DoubleConstNode(Coords coords, double d) {
        super(coords, "double", new Double(d));
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.doubleType;
    }

    @Override
    protected ConstNode doCastTo(TypeNode typeNode) {
        Double d = (Double)this.getValue();
        double d2 = d;
        if (typeNode.isEqual(BasicTypeNode.byteType)) {
            return new ByteConstNode(this.getCoords(), (byte)d2);
        }
        if (typeNode.isEqual(BasicTypeNode.shortType)) {
            return new ShortConstNode(this.getCoords(), (short)d2);
        }
        if (typeNode.isEqual(BasicTypeNode.intType)) {
            return new IntConstNode(this.getCoords(), (int)d2);
        }
        if (typeNode.isEqual(BasicTypeNode.longType)) {
            return new LongConstNode(this.getCoords(), (long)d2);
        }
        if (typeNode.isEqual(BasicTypeNode.floatType)) {
            return new FloatConstNode(this.getCoords(), (float)d2);
        }
        if (typeNode.isEqual(BasicTypeNode.stringType)) {
            return new StringConstNode(this.getCoords(), d.toString());
        }
        throw new UnsupportedOperationException();
    }
}

