/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.numeric;

import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.DoubleConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.FloatConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.IntConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.LongConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.ShortConstNode;
import de.unika.ipd.grgen.ast.expr.string.StringConstNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.parser.Coords;

public class ByteConstNode
extends ConstNode {
    public ByteConstNode(Coords coords, byte by) {
        super(coords, "byte", new Byte(by));
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.byteType;
    }

    @Override
    protected ConstNode doCastTo(TypeNode typeNode) {
        Byte by = (Byte)this.getValue();
        byte by2 = by;
        if (typeNode.isEqual(BasicTypeNode.shortType)) {
            return new ShortConstNode(this.getCoords(), by2);
        }
        if (typeNode.isEqual(BasicTypeNode.intType)) {
            return new IntConstNode(this.getCoords(), by2);
        }
        if (typeNode.isEqual(BasicTypeNode.longType)) {
            return new LongConstNode(this.getCoords(), by2);
        }
        if (typeNode.isEqual(BasicTypeNode.floatType)) {
            return new FloatConstNode(this.getCoords(), by2);
        }
        if (typeNode.isEqual(BasicTypeNode.doubleType)) {
            return new DoubleConstNode(this.getCoords(), by2);
        }
        if (typeNode.isEqual(BasicTypeNode.stringType)) {
            return new StringConstNode(this.getCoords(), by.toString());
        }
        throw new UnsupportedOperationException();
    }

    public static String removeSuffix(String string) {
        if (string.endsWith("y") || string.endsWith("Y")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }
}

