/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.numeric;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.numeric.AbsExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class AbsExprNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode argumentExpr;

    public AbsExprNode(Coords coords, ExprNode exprNode) {
        super(coords);
        this.argumentExpr = this.becomeParent(exprNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.argumentExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("arg");
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (this.argumentExpr.getType().isNumericType()) {
            return true;
        }
        this.reportError("The function Math::abs() expects as argument a value of type " + TypeNode.getNumericTypesAsString() + " (but is given a value of type " + this.argumentExpr.getType().getTypeName() + ").");
        return false;
    }

    @Override
    protected IR constructIR() {
        this.argumentExpr = this.argumentExpr.evaluate();
        return new AbsExpr(this.argumentExpr.checkIR(Expression.class));
    }

    @Override
    public TypeNode getType() {
        return this.argumentExpr.getType();
    }

    static {
        AbsExprNode.setName(AbsExprNode.class, "abs expr");
    }
}

