/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.map;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ContainerInitNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.ExprPairNode;
import de.unika.ipd.grgen.ast.type.DeclaredTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.MapTypeNode;
import de.unika.ipd.grgen.ast.util.MemberResolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.ExpressionPair;
import de.unika.ipd.grgen.ir.expr.map.MapInit;
import de.unika.ipd.grgen.ir.type.container.MapType;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class MapInitNode
extends ContainerInitNode {
    private CollectNode<ExprPairNode> mapItems = new CollectNode();
    private BaseNode lhsUnresolved;
    private DeclNode lhs;
    private MapTypeNode mapType;
    private static final MemberResolver<DeclNode> lhsResolver;

    public MapInitNode(Coords coords, IdentNode identNode, MapTypeNode mapTypeNode) {
        super(coords);
        if (identNode != null) {
            this.lhsUnresolved = this.becomeParent(identNode);
        } else {
            this.mapType = mapTypeNode;
        }
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<CollectNode<ExprPairNode>> vector = new Vector<CollectNode<ExprPairNode>>();
        vector.add(this.mapItems);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("mapItems");
        return vector;
    }

    public void addPairItem(ExprPairNode exprPairNode) {
        this.mapItems.addChild(exprPairNode);
    }

    @Override
    protected boolean resolveLocal() {
        if (this.lhsUnresolved != null) {
            if (!lhsResolver.resolve(this.lhsUnresolved)) {
                return false;
            }
            this.lhs = lhsResolver.getResult(DeclNode.class);
            return lhsResolver.finish();
        }
        if (this.mapType == null) {
            this.mapType = this.createMapType();
        }
        return this.mapType.resolve();
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = true;
        MapTypeNode mapTypeNode = this.getContainerType();
        for (ExprPairNode exprPairNode : this.mapItems.getChildren()) {
            ExprNode exprNode;
            if (exprPairNode.keyExpr.getType() != mapTypeNode.keyType) {
                if (!this.isInitInModel()) {
                    exprNode = exprPairNode.keyExpr;
                    exprPairNode.keyExpr = exprPairNode.keyExpr.adjustType(mapTypeNode.keyType, this.getCoords());
                    exprPairNode.switchParenthood(exprNode, exprPairNode.keyExpr);
                    if (exprPairNode.keyExpr == ConstNode.getInvalid()) {
                        bl = false;
                        exprNode.reportError("The key type " + exprNode.getType().toStringWithDeclarationCoords() + " of the initializer does not fit to the key type " + mapTypeNode.keyType.toStringWithDeclarationCoords() + " of the map (" + mapTypeNode.getTypeName() + ").");
                    }
                } else {
                    bl = false;
                    exprPairNode.keyExpr.reportError("The key type " + exprPairNode.keyExpr.getType().toStringWithDeclarationCoords() + " of the initializer does not fit to the key type " + mapTypeNode.keyType.toStringWithDeclarationCoords() + " of the map (" + mapTypeNode.getTypeName() + " -- all items must be of exactly the same type).");
                }
            }
            if (exprPairNode.valueExpr.getType() == mapTypeNode.valueType) continue;
            if (this.mapType != null) {
                exprNode = exprPairNode.valueExpr;
                exprPairNode.valueExpr = exprPairNode.valueExpr.adjustType(mapTypeNode.valueType, this.getCoords());
                exprPairNode.switchParenthood(exprNode, exprPairNode.valueExpr);
                if (exprPairNode.valueExpr != ConstNode.getInvalid()) continue;
                bl = false;
                exprNode.reportError("The value type " + exprNode.getType().toStringWithDeclarationCoords() + " of the initializer does not fit to the value type " + mapTypeNode.valueType.toStringWithDeclarationCoords() + " of the map (" + mapTypeNode.getTypeName() + ").");
                continue;
            }
            bl = false;
            exprPairNode.valueExpr.reportError("The value type " + exprPairNode.valueExpr.getType().toStringWithDeclarationCoords() + " of the initializer does not fit to the value type " + mapTypeNode.valueType.toStringWithDeclarationCoords() + " of the map (" + mapTypeNode.getTypeName() + " -- all items must be of exactly the same type).");
        }
        if (!this.isConstant() && this.lhs != null) {
            this.reportError("Only constant items are allowed in a map initialization in the model.");
            bl = false;
        }
        return bl;
    }

    private MapTypeNode createMapType() {
        TypeNode typeNode = this.mapItems.getChildren().iterator().next().keyExpr.getType();
        TypeNode typeNode2 = this.mapItems.getChildren().iterator().next().valueExpr.getType();
        IdentNode identNode = ((DeclaredTypeNode)typeNode).getIdentNode();
        IdentNode identNode2 = ((DeclaredTypeNode)typeNode2).getIdentNode();
        return new MapTypeNode(identNode, identNode2);
    }

    public final boolean isConstant() {
        for (ExprPairNode exprPairNode : this.mapItems.getChildren()) {
            if (!(exprPairNode.keyExpr instanceof ConstNode) && !MapInitNode.isEnumValue(exprPairNode.keyExpr)) {
                return false;
            }
            if (exprPairNode.valueExpr instanceof ConstNode || MapInitNode.isEnumValue(exprPairNode.valueExpr)) continue;
            return false;
        }
        return true;
    }

    public final boolean areKeysConstant() {
        for (ExprPairNode exprPairNode : this.mapItems.getChildren()) {
            if (exprPairNode.keyExpr instanceof ConstNode || MapInitNode.isEnumValue(exprPairNode.keyExpr)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(ConstNode constNode) {
        for (ExprPairNode exprPairNode : this.mapItems.getChildren()) {
            if (!(exprPairNode.keyExpr instanceof ConstNode)) continue;
            ConstNode constNode2 = (ConstNode)exprPairNode.keyExpr;
            if (!constNode.getValue().equals(constNode2.getValue())) continue;
            return true;
        }
        return false;
    }

    public ExprNode getAtIndex(ConstNode constNode) {
        for (ExprPairNode exprPairNode : this.mapItems.getChildren()) {
            if (!(exprPairNode.keyExpr instanceof ConstNode)) continue;
            ConstNode constNode2 = (ConstNode)exprPairNode.keyExpr;
            if (!constNode.getValue().equals(constNode2.getValue())) continue;
            return exprPairNode.valueExpr;
        }
        return null;
    }

    @Override
    public MapTypeNode getContainerType() {
        assert (this.isResolved());
        if (this.lhs != null) {
            TypeNode typeNode = this.lhs.getDeclType();
            return (MapTypeNode)typeNode;
        }
        return this.mapType;
    }

    @Override
    public boolean isInitInModel() {
        return this.mapType == null;
    }

    public CollectNode<ExprPairNode> getItems() {
        return this.mapItems;
    }

    @Override
    protected IR constructIR() {
        ExprPairNode exprPairNode2;
        Vector<ExpressionPair> vector = new Vector<ExpressionPair>();
        for (ExprPairNode exprPairNode2 : this.mapItems.getChildren()) {
            vector.add(exprPairNode2.getExpressionPair());
        }
        Iterator<ExprPairNode> iterator = this.lhs != null ? this.lhs.getEntity() : null;
        exprPairNode2 = this.mapType != null ? this.mapType.checkIR(MapType.class) : null;
        return new MapInit((Collection<ExpressionPair>)vector, (Entity)((Object)iterator), (MapType)((Object)exprPairNode2), this.isConstant());
    }

    public MapInit getMapInit() {
        return this.checkIR(MapInit.class);
    }

    public static String getKindStr() {
        return "map initialization";
    }

    static {
        MapInitNode.setName(MapInitNode.class, "map init");
        lhsResolver = new MemberResolver();
    }
}

