/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.map;

import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.map.MapFunctionMethodInvocationBaseExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.IntTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.type.container.MapTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.map.MapAsArrayExpr;
import de.unika.ipd.grgen.parser.Coords;

public class MapAsArrayNode
extends MapFunctionMethodInvocationBaseExprNode {
    private ArrayTypeNode arrayTypeNode;

    public MapAsArrayNode(Coords coords, ExprNode exprNode) {
        super(coords, exprNode);
    }

    @Override
    protected boolean resolveLocal() {
        this.arrayTypeNode = new ArrayTypeNode(this.getTargetType().valueTypeUnresolved);
        return this.arrayTypeNode.resolve();
    }

    @Override
    protected boolean checkLocal() {
        MapTypeNode mapTypeNode = this.getTargetType();
        if (!(mapTypeNode.keyType instanceof IntTypeNode)) {
            this.targetExpr.reportError("The map function method asArray can only be employed on an object of type map<int,T> (but is employed on an object of type " + mapTypeNode.getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    public TypeNode getType() {
        return this.arrayTypeNode;
    }

    @Override
    protected IR constructIR() {
        this.targetExpr = this.targetExpr.evaluate();
        return new MapAsArrayExpr(this.targetExpr.checkIR(Expression.class), this.getType().getType());
    }

    static {
        MapAsArrayNode.setName(MapAsArrayNode.class, "map as array expression");
    }
}

